/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-12 18:36:15 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `pp5_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `pp5_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `pp5_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=486845 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2266 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `pp5_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=36551 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=231661 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7784 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=101945 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `pp5_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=56962 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=137553 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `pp5_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `pp5_users` VALUES 
("2","webadmin","$wp$2y$10$gcWoLSsEdatPVJKfBwpMgOp.Wtd2RvGYikIEBw.AGU39KWsPb8LM6","webadmin","webadmin@eolis.net","","2019-03-04 14:05:48","","0","webadmin"),
("3","cn099","$wp$2y$10$RPg1UktHxtgc7yzfZP8pfuPSQi7j56fVFs6cif21eNpTue41a/.Ma","cn099","contact@latoileclairee.fr","","2019-03-04 14:07:30","","0","cn099"),
("4","mdurand","$P$BmoDJaeCPg5RYw7t5ThIs2dxjr9juM.","mdurand","mdurand@benefacere.fr","","2019-04-02 12:48:31","1710196385:$P$BTbHxvWrqI5KGb4VQfADIUOPhOyl5k1","0","mdurand"),
("5","orange_admin","$P$Bfw5PM6UqBDBSJftgnwADXVlVIDQ.a/","orange_admin","antoine@orangecarre.fr","","2019-06-25 13:27:49","","0","orange_admin"),
("6","CPS19cbd","$P$BzzeYMgfR2YD3RgNbrZrZvjtXEe0w1.","cps19cbd","christine.beckerdargent@gmail.com","","2019-08-26 14:17:40","","0","CPS19cbd"),
("7","tetedelinop","$wp$2y$10$2zLITyA.9gLpQKt1.g4dquEZmssWwUZDakoKaD8DumDnLdUBVRC8S","tetedelinop","tetedelinop@gmail.com","","2021-03-23 10:27:09","","0","tetedelinop"),
("8","sjeanson","$wp$2y$10$GQCcCM9GQNJkpr.yRNsFx.pJqBmbdJmt9yuB4CkmAy.3Plv7.2hOi","sjeanson","sabine.jeanson.b@gmail.com","","2021-09-21 07:02:55","","0","sjeanson"),
("9","Isabelle COLIN","$wp$2y$10$05KbjW/HeyVOFqlWg2DSjurwC.sj5MyWqxiLgQlKfnU1EPRGFZRli","isabelle-colin","colin_isabelle@yahoo.fr","http://www.asso-envole.fr","2024-09-27 15:54:12","","0","Isabelle Colin"),
("10","Sophie Boyer","$P$BW0EhBsL9M8oHoh0GeEnmZLehZWdO70","sophie-boyer","sophie.boyer.pag@gmail.com","","2024-12-08 13:47:42","","0","Sophie BOYER"),
("11","gferchaud","$wp$2y$10$goaS7rbYdeNJ5CTdqHOyue4jvFa.j4fhcxkXb1kWpVZzM0mBm2ciW","gferchaud","guillaume.ferchaud@outlook.fr","","2026-01-12 15:25:52","","0","gferchaud");

INSERT IGNORE INTO `pp5_usermeta` VALUES 
("19","2","nickname","webadmin"),
("20","2","first_name",""),
("21","2","last_name",""),
("22","2","description",""),
("23","2","rich_editing","true"),
("24","2","syntax_highlighting","true"),
("25","2","comment_shortcuts","false"),
("26","2","admin_color","fresh"),
("27","2","use_ssl","0"),
("28","2","show_admin_bar_front","true"),
("29","2","locale",""),
("30","2","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("31","2","pp5_user_level","10"),
("32","2","dismissed_wp_pointers","wp496_privacy"),
("33","3","nickname","cn099"),
("34","3","first_name",""),
("35","3","last_name",""),
("36","3","description",""),
("37","3","rich_editing","true"),
("38","3","syntax_highlighting","true"),
("39","3","comment_shortcuts","false"),
("40","3","admin_color","fresh"),
("41","3","use_ssl","0"),
("42","3","show_admin_bar_front","false"),
("43","3","locale",""),
("44","3","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("45","3","pp5_user_level","10"),
("46","3","dismissed_wp_pointers","wp496_privacy"),
("48","3","pp5_dashboard_quick_press_last_post_id","2245"),
("49","3","community-events-location","a:1:{s:2:\"ip\";s:10:\"93.23.17.0\";}"),
("51","2","pp5_dashboard_quick_press_last_post_id","2264"),
("52","2","community-events-location","a:1:{s:2:\"ip\";s:9:\"2.13.62.0\";}"),
("53","2","pp5_user-settings","libraryContent=browse"),
("54","2","pp5_user-settings-time","1551737158"),
("58","3","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("59","3","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("61","3","nav_menu_recently_edited","2"),
("64","3","pp5_user-settings","libraryContent=browse"),
("65","3","pp5_user-settings-time","1566919583"),
("77","4","nickname","mdurand"),
("78","4","first_name",""),
("79","4","last_name",""),
("80","4","description",""),
("81","4","rich_editing","true"),
("82","4","syntax_highlighting","true"),
("83","4","comment_shortcuts","false"),
("84","4","admin_color","fresh"),
("85","4","use_ssl","0"),
("86","4","show_admin_bar_front","true"),
("87","4","locale",""),
("88","4","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("89","4","pp5_user_level","10"),
("90","4","dismissed_wp_pointers","wp496_privacy"),
("91","4","default_password_nag",""),
("93","4","pp5_dashboard_quick_press_last_post_id","1404"),
("94","4","community-events-location","a:1:{s:2:\"ip\";s:10:\"91.168.2.0\";}"),
("96","3","pp5_media_library_mode","grid"),
("97","4","nav_menu_recently_edited","2"),
("98","4","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("99","4","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("100","4","pp5_user-settings","libraryContent=browse&editor=tinymce&hidetb=0"),
("101","4","pp5_user-settings-time","1555598141"),
("102","2","closedpostboxes_dashboard","a:0:{}"),
("103","2","metaboxhidden_dashboard","a:2:{i:0;s:21:\"dashboard_quick_press\";i:1;s:17:\"dashboard_primary\";}"),
("104","2","nav_menu_recently_edited","2"),
("105","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("106","2","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("109","4","closedpostboxes_dashboard","a:0:{}"),
("110","4","metaboxhidden_dashboard","a:0:{}"),
("111","5","nickname","orange_admin"),
("112","5","first_name",""),
("113","5","last_name",""),
("114","5","description",""),
("115","5","rich_editing","true"),
("116","5","syntax_highlighting","true"),
("117","5","comment_shortcuts","false"),
("118","5","admin_color","fresh"),
("119","5","use_ssl","0"),
("120","5","show_admin_bar_front","true"),
("121","5","locale",""),
("122","5","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("123","5","pp5_user_level","10"),
("124","5","dismissed_wp_pointers","wp496_privacy"),
("125","5","default_password_nag",""),
("127","5","pp5_dashboard_quick_press_last_post_id","1202"),
("128","5","community-events-location","a:1:{s:2:\"ip\";s:12:\"90.105.162.0\";}"),
("135","6","nickname","CPS19cbd"),
("136","6","first_name",""),
("137","6","last_name",""),
("138","6","description",""),
("139","6","rich_editing","true"),
("140","6","syntax_highlighting","true"),
("141","6","comment_shortcuts","false"),
("142","6","admin_color","fresh"),
("143","6","use_ssl","0"),
("144","6","show_admin_bar_front","true"),
("145","6","locale",""),
("146","6","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("147","6","pp5_user_level","10"),
("148","6","dismissed_wp_pointers",""),
("149","6","default_password_nag",""),
("151","6","pp5_dashboard_quick_press_last_post_id","2223"),
("152","6","community-events-location","a:1:{s:2:\"ip\";s:18:\"2a01:e0a:11:be80::\";}"),
("153","6","pp5_user-settings","libraryContent=browse&editor=tinymce&advImgDetails=show"),
("154","6","pp5_user-settings-time","1697736406"),
("160","6","closedpostboxes_dashboard","a:1:{i:0;s:19:\"dashboard_right_now\";}"),
("161","6","metaboxhidden_dashboard","a:0:{}"),
("171","2","wpcf7_hide_welcome_panel_on","a:1:{i:0;s:3:\"5.1\";}"),
("187","2","pp5_googlesitekit_site_verification_file","0e7d67b4a0884798"),
("188","2","pp5_googlesitekit_access_token_expires_in","3599"),
("189","2","pp5_googlesitekit_access_token_created_at","1606899054"),
("190","2","pp5_googlesitekit_access_token","7ijEMkKmXmM3Dc8jbkCZp1NadzNjamJWWnB4S0hqSUI3VTNlM25qK2l5VkRla1Q0cFlCaGJsekltQWpNck50cVIwcWd1R3JPbmd0dm53alRTS3VRdGVlL2NpS3A2MlE4ekQ3VmlFcmtJMitJdGVYRVk2bUVYM1hpbWNqSGZ0TGFhNzNSN1J4eTVkR21VUzM1SHhCemRVc2ltbDdBTWFIeWRsdzJkUEYvWGV1ZE96LysxMzNQczFpNkdRbm13TjFGcWVrYStDMGMzYk45RG0vZWdZaFBuV1lETTdqbU5HN0pUcWdES0Z3ZXh6TmcxUXA4TmFNbWRNb3lxeTRoeHlvMUZSMWFFYkZ2Ymw0TXBDZ212T3FuTXhKWDgvM2NERmt1ZHBwaVhRMCtHUzlGaVcxZTZWdkR2N3NYc3VjZTBreFVjNUlCRGkvVVQ3OUlVanpONXRaMmhldz0="),
("191","2","pp5_googlesitekit_refresh_token","nsKWh4RPs7Ni6pVb8pLlTHpLZ1NrdUNTUFMra3AwNVFRNC83ZS9GN21KTjdHa01EbWtVcmdiY2c4dlh5bUx5TlJlSkU1MzREYkZZSHpwU2I5MHFFcDY2TnNMSVE5R1RzZmY1ZXhkRXBHNXNTMGxlS1NaYVNWMGluTDJ5cGQrQ0c3VHFmeXNYZS94NUJvUmMyZU13YU83OWJ4dklRNDBQQzFRcGlma1VEY2RJbDJka3AxZHVmcW0xakd2eHFmSU9DL1g3cFJpMmMxdktoY1NMWE9MLzBwRGtTdGpzdS9mbkJQY0dKUTBOQklHQnA4SkJkYXpsV045T3F1S29wek1md0gxcWEvR3BlbG5SSVhDbWFWQk14WGk1eHFDaUJLOXRzaDR2WHluMVBubVl6S1NzQk5hSzY2VzBSbStxbUxad0tEWVFrS0p0UkMwL1VIcGRR"),
("192","2","pp5_googlesitekit_auth_scopes","a:11:{i:0;s:5:\"email\";i:1;s:7:\"profile\";i:2;s:46:\"https://www.googleapis.com/auth/analytics.edit\";i:3;s:54:\"https://www.googleapis.com/auth/analytics.manage.users\";i:4;s:50:\"https://www.googleapis.com/auth/analytics.readonly\";i:5;s:41:\"https://www.googleapis.com/auth/analytics\";i:6;s:42:\"https://www.googleapis.com/auth/webmasters\";i:7;s:48:\"https://www.googleapis.com/auth/siteverification\";i:8;s:6:\"openid\";i:9;s:48:\"https://www.googleapis.com/auth/userinfo.profile\";i:10;s:46:\"https://www.googleapis.com/auth/userinfo.email\";}"),
("193","2","pp5_googlesitekit_profile","a:2:{s:5:\"email\";s:22:\"raphael.baer@gmail.com\";s:5:\"photo\";s:120:\"https://lh3.googleusercontent.com/-Ekama7k_Nbc/AAAAAAAAAAI/AAAAAAAAAAA/ACHi3rdsbQrwNdK392C64k2ckzFSLtUsjg/s100/photo.jpg\";}"),
("194","2","pp5_googlesitekit_site_verified_meta","verified"),
("196","2","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:38:\"dashboard_right_now,dashboard_activity\";s:4:\"side\";s:63:\"dashboard_quick_press,dashboard_primary,google_dashboard_widget\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("202","2","closedpostboxes_post","a:0:{}"),
("203","2","metaboxhidden_post","a:0:{}"),
("205","2","pp5_googlesitekit_transient_timeout_googlesitekit_user_input_settings","1617099832"),
("206","2","pp5_googlesitekit_transient_googlesitekit_user_input_settings","a:2:{s:4:\"role\";a:3:{s:6:\"values\";a:0:{}s:5:\"scope\";s:4:\"user\";s:10:\"answeredBy\";i:0;}s:13:\"postFrequency\";a:3:{s:6:\"values\";a:0:{}s:5:\"scope\";s:4:\"user\";s:10:\"answeredBy\";i:0;}}"),
("207","2","pp5_googlesitekit_user_input_state","missing"),
("211","7","nickname","tetedelinop"),
("212","7","first_name",""),
("213","7","last_name",""),
("214","7","description",""),
("215","7","rich_editing","true"),
("216","7","syntax_highlighting","true"),
("217","7","comment_shortcuts","false"),
("218","7","admin_color","fresh"),
("219","7","use_ssl","0"),
("220","7","show_admin_bar_front","true"),
("221","7","locale",""),
("222","7","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("223","7","pp5_user_level","10"),
("224","7","dismissed_wp_pointers","plugin_editor_notice"),
("226","7","default_password_nag",""),
("228","7","pp5_dashboard_quick_press_last_post_id","2238"),
("229","7","community-events-location","a:1:{s:2:\"ip\";s:20:\"2001:861:5b02:f890::\";}"),
("230","7","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:78:\"dashboard_php_nag,dashboard_site_health,dashboard_right_now,dashboard_activity\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("232","2","pp5_googlesitekit_error_code","invalid \'client_id\' or \'client_secret\'"),
("233","7","pp5_user-settings","libraryContent=browse"),
("234","7","pp5_user-settings-time","1616505595"),
("236","8","nickname","sjeanson"),
("237","8","first_name",""),
("238","8","last_name",""),
("239","8","description",""),
("240","8","rich_editing","true"),
("241","8","syntax_highlighting","true"),
("242","8","comment_shortcuts","false"),
("243","8","admin_color","fresh"),
("244","8","use_ssl","0"),
("245","8","show_admin_bar_front","true"),
("246","8","locale",""),
("247","8","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("248","8","pp5_user_level","10"),
("249","8","dismissed_wp_pointers",""),
("250","8","default_password_nag",""),
("252","8","pp5_dashboard_quick_press_last_post_id","2263"),
("253","8","community-events-location","a:1:{s:2:\"ip\";s:21:\"2a02:8428:819c:9801::\";}"),
("257","6","wfls-last-login","1740247738"),
("261","8","wfls-last-login","1768231507"),
("266","3","wfls-last-login","1760432920"),
("268","2","wfls-last-login","1768224874"),
("270","7","wfls-last-login","1757408001"),
("273","2","session_tokens","a:1:{s:64:\"5282939c7726066c450e6635bde33776e678b017ca908f0e8a32fe78e378dde0\";a:4:{s:10:\"expiration\";i:1769434474;s:2:\"ip\";s:10:\"2.13.62.98\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768224874;}}"),
("277","8","session_tokens","a:1:{s:64:\"c25e151ae2858aefb769b5630a6f9131ec1793f2f1aa464c301d31f3204a1d48\";a:4:{s:10:\"expiration\";i:1768404307;s:2:\"ip\";s:39:\"2a02:8428:819c:9801:352d:133a:fb39:9938\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768231507;}}"),
("281","6","closedpostboxes_agenda","a:0:{}"),
("282","6","metaboxhidden_agenda","a:1:{i:0;s:7:\"slugdiv\";}"),
("283","6","meta-box-order_agenda","a:4:{s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:0:\"\";s:6:\"normal\";s:17:\"submitdiv,slugdiv\";s:8:\"advanced\";s:23:\"acf-group_5cab45deede3b\";}"),
("284","6","screen_layout_agenda","2"),
("291","7","session_tokens","a:1:{s:64:\"5d5f5f996396eff1382d44dfa5a54a7e2278aebd0a1ac8f315f0d45452d62b39\";a:4:{s:10:\"expiration\";i:1758617601;s:2:\"ip\";s:37:\"2001:861:5b02:f890:38dd:ba81:287:7fdb\";s:2:\"ua\";s:84:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:142.0) Gecko/20100101 Firefox/142.0\";s:5:\"login\";i:1757408001;}}"),
("292","7","nav_menu_recently_edited","2"),
("293","7","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("294","7","metaboxhidden_nav-menus","a:3:{i:0;s:20:\"add-post-type-agenda\";i:1;s:24:\"add-post-type-ressources\";i:2;s:12:\"add-post_tag\";}"),
("296","6","pp5_persisted_preferences","a:2:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:0;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-04-24T15:26:09.834Z\";}"),
("300","8","pp5_persisted_preferences","a:3:{s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2026-01-08T13:11:43.889Z\";s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";}}}"),
("302","3","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("307","9","nickname","Isabelle COLIN"),
("308","9","first_name","Isabelle"),
("309","9","last_name","Colin"),
("310","9","description",""),
("311","9","rich_editing","true"),
("312","9","syntax_highlighting","true"),
("313","9","comment_shortcuts","false"),
("314","9","admin_color","fresh"),
("315","9","use_ssl","0"),
("316","9","show_admin_bar_front","true"),
("317","9","locale","fr_FR"),
("318","9","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("319","9","pp5_user_level","10"),
("320","9","dismissed_wp_pointers",""),
("321","9","session_tokens","a:1:{s:64:\"d5c843a63cb783d89496a2ae54f569bea2d4ed5f6b0ff61beb37d48d044c4faf\";a:4:{s:10:\"expiration\";i:1767477816;s:2:\"ip\";s:36:\"2a01:e0a:11:be80:3caa:61cb:5b00:1912\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1766268216;}}"),
("322","9","wfls-last-login","1766268216"),
("323","9","pp5_dashboard_quick_press_last_post_id","2256"),
("324","9","community-events-location","a:1:{s:2:\"ip\";s:18:\"2a01:e0a:11:be80::\";}"),
("325","9","pp5_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-10-02T17:12:26.610Z\";}"),
("327","9","pp5_user-settings","libraryContent=browse"),
("328","9","pp5_user-settings-time","1732749654"),
("329","10","nickname","Sophie Boyer"),
("330","10","first_name","Sophie"),
("331","10","last_name","BOYER"),
("332","10","description",""),
("333","10","rich_editing","true"),
("334","10","syntax_highlighting","true"),
("335","10","comment_shortcuts","false"),
("336","10","admin_color","fresh"),
("337","10","use_ssl","0"),
("338","10","show_admin_bar_front","true"),
("339","10","locale",""),
("340","10","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("341","10","pp5_user_level","10"),
("342","10","dismissed_wp_pointers",""),
("343","10","default_password_nag",""),
("344","10","session_tokens","a:1:{s:64:\"80bbfc482f7e9fac57b3532b931c8590e2df4b99bd7437676c64499b9a6490d6\";a:4:{s:10:\"expiration\";i:1733853556;s:2:\"ip\";s:37:\"2a01:cb05:9751:e300:1b6:466:64d5:156e\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36\";s:5:\"login\";i:1733680756;}}"),
("345","10","wfls-last-login","1733680757"),
("346","10","pp5_dashboard_quick_press_last_post_id","2208"),
("347","10","community-events-location","a:1:{s:2:\"ip\";s:21:\"2a01:cb05:9751:e300::\";}"),
("348","10","pp5_persisted_preferences","a:3:{s:4:\"core\";a:4:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"editorMode\";s:6:\"visual\";s:15:\"distractionFree\";b:0;s:12:\"fixedToolbar\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-12-08T22:11:08.120Z\";}"),
("353","7","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("357","2","pp5_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-10-10T12:51:07.835Z\";}"),
("361","3","pp5_persisted_preferences","a:4:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:0;}s:9:\"_modified\";s:24:\"2025-10-14T09:10:39.011Z\";}"),
("362","8","meta-box-order_post","a:4:{s:6:\"normal\";s:0:\"\";s:8:\"advanced\";s:23:\"acf-group_5d5a7421db568\";s:4:\"side\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";}"),
("363","8","nav_menu_recently_edited","2"),
("364","8","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("365","8","metaboxhidden_nav-menus","a:3:{i:0;s:20:\"add-post-type-agenda\";i:1;s:24:\"add-post-type-ressources\";i:2;s:12:\"add-post_tag\";}"),
("366","2","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("367","11","nickname","gferchaud"),
("368","11","first_name",""),
("369","11","last_name",""),
("370","11","description",""),
("371","11","rich_editing","true"),
("372","11","syntax_highlighting","true"),
("373","11","comment_shortcuts","false"),
("374","11","admin_color","fresh"),
("375","11","use_ssl","0"),
("376","11","show_admin_bar_front","true"),
("377","11","locale",""),
("378","11","pp5_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("379","11","pp5_user_level","10"),
("380","11","dismissed_wp_pointers",""),
("381","11","session_tokens","a:1:{s:64:\"742eb4f9be53e10280b787b817d4d19f98b0f3a4e458d67ab3d1cbedbb61e162\";a:4:{s:10:\"expiration\";i:1768408294;s:2:\"ip\";s:37:\"2a01:e0a:58d:f700:f489:a73a:cb0b:c2da\";s:2:\"ua\";s:101:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768235494;}}"),
("382","11","wfls-last-login","1768235494"),
("383","11","pp5_dashboard_quick_press_last_post_id","2265"),
("384","11","community-events-location","a:1:{s:2:\"ip\";s:19:\"2a01:e0a:58d:f700::\";}");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("93","20230707_090748_dble4a2h_plateformecolle","cd487783b341d73a2093_20230707070748","100","2023-07-07 09:07:48","System","{\n    \"ID\": 93,\n    \"Created\": \"2023-07-07 07:07:48\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230707_090748_dble4a2h_plateformecolle\",\n    \"Hash\": \"cd487783b341d73a2093_20230707070748\",\n    \"NameHash\": \"20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748\",\n    \"Type\": 2,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748_scan.json\",\n    \"timer_start\": 1688713669.224983,\n    \"Runtime\": \"7.194 sec.\",\n    \"ExeSize\": \"71.63KB\",\n    \"ZipSize\": \"4.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": \"on\",\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 4653356,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748_installer.php\",\n        \"Size\": 73346,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"R9D7dolK7czknuHiFPrUkaWn6edORWSmTudmzCHmuNnKyLKSmf5KThHOV6\\/\\/+FXRp2S3g3JTAgOWCBa\\/bdGAMA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25018,\n            \"tablesSizeOnDisk\": 41811968,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 192,\n                    \"insertedRows\": 195,\n                    \"size\": 180224\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 3904,\n                    \"insertedRows\": 3924,\n                    \"size\": 1867776\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1118,\n                    \"insertedRows\": 1190,\n                    \"size\": 31227904\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 173,\n                    \"insertedRows\": 169,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1268,\n                    \"insertedRows\": 1268,\n                    \"size\": 98304\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 44,\n                    \"insertedRows\": 44,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 261,\n                    \"insertedRows\": 263,\n                    \"size\": 491520\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6351,\n                    \"insertedRows\": 6589,\n                    \"size\": 2637824\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1762,\n                    \"insertedRows\": 1745,\n                    \"size\": 1818624\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6734,\n                    \"insertedRows\": 6590,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2167,\n                    \"insertedRows\": 2159,\n                    \"size\": 589824\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 939,\n                    \"insertedRows\": 939,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 28653853,\n        \"File\": \"20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230707_090748_dble4a2h_plateformecolle_cd487783b341d73a2093_20230707070748_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 4653356,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIGjKd8g1yVOIBxDZwmhqzPFhzrxZ89Ltq3rZiq2kjaGOM81g\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1688713676,\n            \"stopped_timestamp\": 1688713686,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("94","20230718_021217_full18a2h_assoenvolefr","61fa35c5bdc7ae273941_20230718001217","-1","2023-07-18 02:12:17","System","{\n    \"ID\": 94,\n    \"Created\": \"2023-07-18 00:12:17\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230718_021217_full18a2h_assoenvolefr\",\n    \"Hash\": \"61fa35c5bdc7ae273941_20230718001217\",\n    \"NameHash\": \"20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217\",\n    \"Type\": 1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217_scan.json\",\n    \"timer_start\": 1689639146.38495,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 167397092,\n        \"Dirs\": null,\n        \"DirCount\": 976,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6504,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"UU4fHsfm0Dk1VPsc955CwB6byz7df92FIiEkgSeQJOKJ0BZNaVzSqUEiUJavY\\/p6nh2bPO4XiCpvcV9tsu3zxg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 24998,\n            \"tablesSizeOnDisk\": 43974656,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 222,\n                    \"insertedRows\": 230,\n                    \"size\": 131072\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 3904,\n                    \"insertedRows\": 3924,\n                    \"size\": 1867776\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1244,\n                    \"insertedRows\": 1189,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 169,\n                    \"insertedRows\": 169,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1284,\n                    \"insertedRows\": 1312,\n                    \"size\": 98304\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 23,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1523712\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6731,\n                    \"insertedRows\": 6508,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1555,\n                    \"insertedRows\": 1798,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6442,\n                    \"insertedRows\": 6508,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2121,\n                    \"insertedRows\": 2022,\n                    \"size\": 573440\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 28650465,\n        \"File\": \"20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230718_021217_full18a2h_assoenvolefr_61fa35c5bdc7ae273941_20230718001217_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": \"9\",\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("95","20230804_024145_dble4a2h_assoenvolefr","574be1b59edcc53d9052_20230804004145","100","2023-08-04 02:41:45","System","{\n    \"ID\": 95,\n    \"Created\": \"2023-08-04 00:41:45\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230804_024145_dble4a2h_assoenvolefr\",\n    \"Hash\": \"574be1b59edcc53d9052_20230804004145\",\n    \"NameHash\": \"20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145\",\n    \"Type\": 1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145_scan.json\",\n    \"timer_start\": 1691109706.80205,\n    \"Runtime\": \"9.501 sec.\",\n    \"ExeSize\": \"71.62KB\",\n    \"ZipSize\": \"4.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": \"on\",\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 4655685,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145_installer.php\",\n        \"Size\": 73343,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"CA79M2SKD1FiPz+vKLeMyBmyIqoGe6\\/nmpOjD+wi6QUIIXxeJJt6425glFNesXeIyu81+M2uUt2GCW43ybAc3w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 19630,\n            \"tablesSizeOnDisk\": 40828928,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 98304\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 277,\n                    \"insertedRows\": 321,\n                    \"size\": 196608\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 3904,\n                    \"insertedRows\": 3924,\n                    \"size\": 1867776\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1234,\n                    \"insertedRows\": 1189,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 169,\n                    \"insertedRows\": 169,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1247,\n                    \"insertedRows\": 1203,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1523712\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 18,\n                    \"insertedRows\": 20,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 1090,\n                    \"insertedRows\": 6512,\n                    \"size\": 475136\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1647,\n                    \"insertedRows\": 1921,\n                    \"size\": 1277952\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6631,\n                    \"insertedRows\": 6513,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2106,\n                    \"insertedRows\": 2085,\n                    \"size\": 573440\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 1218,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 28798372,\n        \"File\": \"20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230804_024145_dble4a2h_assoenvolefr_574be1b59edcc53d9052_20230804004145_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": \"8\",\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 4655685,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIGqJAsl57bRLaOuZn1CoTJUJ92BncibovvtXU7srYbs008rQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1691109716,\n            \"stopped_timestamp\": 1691109724,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("96","20230818_025756_full18a2h_assoenvolefr","49a833e7d68cf5296947_20230818005756","-1","2023-08-18 02:57:56","System","{\n    \"ID\": 96,\n    \"Created\": \"2023-08-18 00:57:56\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230818_025756_full18a2h_assoenvolefr\",\n    \"Hash\": \"49a833e7d68cf5296947_20230818005756\",\n    \"NameHash\": \"20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756\",\n    \"Type\": 1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756_scan.json\",\n    \"timer_start\": 1692320283.227088,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 167367007,\n        \"Dirs\": null,\n        \"DirCount\": 977,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6503,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"Vy9kJd9I7K+IJIve\\/2ohoRVqLNbgf0u3sK7kJbffmnMUlNdnYrzuxz1t7gvzRk7ep++yCRsosdcU5\\/wOYDCWUA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 23889,\n            \"tablesSizeOnDisk\": 43925504,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 4,\n                    \"size\": 131072\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 263,\n                    \"insertedRows\": 264,\n                    \"size\": 180224\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 3904,\n                    \"insertedRows\": 3924,\n                    \"size\": 1867776\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1182,\n                    \"insertedRows\": 1189,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 169,\n                    \"insertedRows\": 169,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1205,\n                    \"insertedRows\": 1205,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 17,\n                    \"insertedRows\": 17,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6047,\n                    \"insertedRows\": 6510,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1590,\n                    \"insertedRows\": 1625,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6165,\n                    \"insertedRows\": 6510,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2027,\n                    \"insertedRows\": 2054,\n                    \"size\": 589824\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 959,\n                    \"insertedRows\": 959,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 28631315,\n        \"File\": \"20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230818_025756_full18a2h_assoenvolefr_49a833e7d68cf5296947_20230818005756_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": \"9\",\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("97","20230818_111518_full18a2h_assoenvolefr","5e46f26db877e9ee6467_20230818091518","100","2023-08-18 11:15:18","System","{\n    \"ID\": 97,\n    \"Created\": \"2023-08-18 09:15:18\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230818_111518_full18a2h_assoenvolefr\",\n    \"Hash\": \"5e46f26db877e9ee6467_20230818091518\",\n    \"NameHash\": \"20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518\",\n    \"Type\": 2,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518_scan.json\",\n    \"timer_start\": 1692350123.796664,\n    \"Runtime\": \"27.810 sec.\",\n    \"ExeSize\": \"71.63KB\",\n    \"ZipSize\": \"87.73MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 91988024,\n        \"Dirs\": null,\n        \"DirCount\": 977,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6502,\n        \"file_count\": 7480,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518_installer.php\",\n        \"Size\": 73352,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"oKPyvJWKJ07eoDtlYthKbdMywxu34NEsPY6mKygDsLDSloVpKrTXSlCaHlar6avVUfIwtPBc+MFafOsrpV8JPw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 23890,\n            \"tablesSizeOnDisk\": 43925504,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 5,\n                    \"size\": 131072\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 279,\n                    \"insertedRows\": 333,\n                    \"size\": 180224\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 3904,\n                    \"insertedRows\": 3924,\n                    \"size\": 1867776\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1182,\n                    \"insertedRows\": 1190,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 169,\n                    \"insertedRows\": 170,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1205,\n                    \"insertedRows\": 1149,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6047,\n                    \"insertedRows\": 6510,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1590,\n                    \"insertedRows\": 1676,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6165,\n                    \"insertedRows\": 6510,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2027,\n                    \"insertedRows\": 2002,\n                    \"size\": 589824\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 959,\n                    \"insertedRows\": 967,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 29255780,\n        \"File\": \"20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230818_111518_full18a2h_assoenvolefr_5e46f26db877e9ee6467_20230818091518_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 91988024,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIGtlBY1f3hT9ZCC39SqTJp3S-_egn8WzuUGu8Ie4FJTL1dPA\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1692350151,\n            \"stopped_timestamp\": 1692350218,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("98","20230904_020703_dble4a2h_assoenvolefr","e0a3fcb22280a5a81175_20230904000703","100","2023-09-04 02:07:03","System","{\n    \"ID\": 98,\n    \"Created\": \"2023-09-04 00:07:03\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230904_020703_dble4a2h_assoenvolefr\",\n    \"Hash\": \"e0a3fcb22280a5a81175_20230904000703\",\n    \"NameHash\": \"20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703\",\n    \"Type\": 1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703_scan.json\",\n    \"timer_start\": 1693786024.297468,\n    \"Runtime\": \"8.776 sec.\",\n    \"ExeSize\": \"71.62KB\",\n    \"ZipSize\": \"4.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": \"on\",\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 4653844,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703_installer.php\",\n        \"Size\": 73343,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"NUf7Pb0qUYp5kwv\\/3adyWADE3XLLQumN2kEIHRbRjCGGhtn0zaf\\/TtLrsYegfgO7EcXmXwBSKE2rp4Ai1Mqc+g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 24308,\n            \"tablesSizeOnDisk\": 46809088,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 6,\n                    \"insertedRows\": 6,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 229,\n                    \"insertedRows\": 229,\n                    \"size\": 1163264\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4254,\n                    \"insertedRows\": 4232,\n                    \"size\": 1884160\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1180,\n                    \"insertedRows\": 1200,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 169,\n                    \"insertedRows\": 169,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1402,\n                    \"insertedRows\": 1405,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 16,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6000,\n                    \"insertedRows\": 6514,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1538,\n                    \"insertedRows\": 1666,\n                    \"size\": 2342912\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6136,\n                    \"insertedRows\": 6514,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2101,\n                    \"insertedRows\": 2030,\n                    \"size\": 1343488\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 939,\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 28889534,\n        \"File\": \"20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230904_020703_dble4a2h_assoenvolefr_e0a3fcb22280a5a81175_20230904000703_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": \"8\",\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 4653844,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIGxpLJu9zYdC4OsQCKxwWwiuKqjismxF5tUg6qqSYpanpTOQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1693786033,\n            \"stopped_timestamp\": 1693786040,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("99","20230918_020438_full18a2h_assoenvolefr","34ab847a69c2c1449216_20230918000438","-1","2023-09-18 02:04:38","System","{\n    \"ID\": 99,\n    \"Created\": \"2023-09-18 00:04:38\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230918_020438_full18a2h_assoenvolefr\",\n    \"Hash\": \"34ab847a69c2c1449216_20230918000438\",\n    \"NameHash\": \"20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438\",\n    \"Type\": 1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438_scan.json\",\n    \"timer_start\": 1694995482.78708,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 168237759,\n        \"Dirs\": null,\n        \"DirCount\": 978,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6514,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"65M1Px0SIFJqd7T1CTW+HAWMU6kVFF+Kyw7uc+vOL4qWGENitGFkMxCrldJENG\\/OFzoZe90g3ROYgQEj9n70IQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20416,\n            \"tablesSizeOnDisk\": 43630592,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 229376\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 252,\n                    \"insertedRows\": 257,\n                    \"size\": 1163264\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4327,\n                    \"size\": 1900544\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1126,\n                    \"insertedRows\": 1231,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 179,\n                    \"insertedRows\": 179,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1484,\n                    \"insertedRows\": 1482,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 23,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 11,\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 1203,\n                    \"insertedRows\": 6523,\n                    \"size\": 491520\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 2145,\n                    \"insertedRows\": 1652,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6333,\n                    \"insertedRows\": 6524,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2060,\n                    \"insertedRows\": 2054,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 962,\n                    \"insertedRows\": 1229,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30367768,\n        \"File\": \"20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230918_020438_full18a2h_assoenvolefr_34ab847a69c2c1449216_20230918000438_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": \"9\",\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("100","20230918_151421_full18a2h_assoenvolefr","998e69edec4f8e9b2491_20230918131421","100","2023-09-18 15:14:21","System","{\n    \"ID\": 100,\n    \"Created\": \"2023-09-18 13:14:21\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230918_151421_full18a2h_assoenvolefr\",\n    \"Hash\": \"998e69edec4f8e9b2491_20230918131421\",\n    \"NameHash\": \"20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421\",\n    \"Type\": 2,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421_scan.json\",\n    \"timer_start\": 1695042864.867703,\n    \"Runtime\": \"17.279 sec.\",\n    \"ExeSize\": \"71.63KB\",\n    \"ZipSize\": \"88.66MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 92964797,\n        \"Dirs\": null,\n        \"DirCount\": 978,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6513,\n        \"file_count\": 7492,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421_installer.php\",\n        \"Size\": 73352,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"rNwDFi\\/4IvgSQiHd3VnTgm+r3WuHd3rh4svFIXhVT25yQDQrGv87bv4y8WdfSLFO6qOxnWwFjcTEJWMtDg2o\\/w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25664,\n            \"tablesSizeOnDisk\": 46841856,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": 8,\n                    \"size\": 262144\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 276,\n                    \"insertedRows\": 333,\n                    \"size\": 1163264\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4327,\n                    \"size\": 1900544\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1191,\n                    \"insertedRows\": 1232,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 179,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1484,\n                    \"insertedRows\": 1464,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 5,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6963,\n                    \"insertedRows\": 6523,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1534,\n                    \"insertedRows\": 1767,\n                    \"size\": 2342912\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6375,\n                    \"insertedRows\": 6524,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2048,\n                    \"insertedRows\": 2028,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 951,\n                    \"insertedRows\": 951,\n                    \"size\": 278528\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31037157,\n        \"File\": \"20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230918_151421_full18a2h_assoenvolefr_998e69edec4f8e9b2491_20230918131421_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 92964797,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIG1T3PymmnPBilVUWB8ZC27VTyn-sAjvuVjZYL2yfR1-spBw\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1695042882,\n            \"stopped_timestamp\": 1695042949,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("101","20230919_100605_full18a2h_assoenvolefr","e40e037f07f9f9355270_20230919080605","100","2023-09-19 10:06:05","System","{\n    \"ID\": 101,\n    \"Created\": \"2023-09-19 08:06:05\",\n    \"Version\": \"4.5.0\",\n    \"VersionWP\": \"5.9.7\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20230919_100605_full18a2h_assoenvolefr\",\n    \"Hash\": \"e40e037f07f9f9355270_20230919080605\",\n    \"NameHash\": \"20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605\",\n    \"Type\": 2,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605_scan.json\",\n    \"timer_start\": 1695110770.991128,\n    \"Runtime\": \"24.753 sec.\",\n    \"ExeSize\": \"71.63KB\",\n    \"ZipSize\": \"88.69MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 92996191,\n        \"Dirs\": null,\n        \"DirCount\": 978,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6516,\n        \"file_count\": 7495,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605_installer.php\",\n        \"Size\": 73352,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"iXbIJPjX00K1tNsR7h4vq8p5m8r4o4gPHE17S1XyKtvN33vKo327XS5i5QOT4o11wnf6atqDpKVEVPctjWiU0Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 35,\n            \"tablesFinalCount\": 35,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 24951,\n            \"tablesSizeOnDisk\": 46891008,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 294912\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 241,\n                    \"insertedRows\": 257,\n                    \"size\": 1163264\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4329,\n                    \"size\": 1900544\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1167,\n                    \"insertedRows\": 1233,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 179,\n                    \"insertedRows\": 179,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1481,\n                    \"insertedRows\": 1489,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": 20,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 260,\n                    \"insertedRows\": 262,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6125,\n                    \"insertedRows\": 6523,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1681,\n                    \"insertedRows\": 1863,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6367,\n                    \"insertedRows\": 6524,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2082,\n                    \"insertedRows\": 2057,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 951,\n                    \"insertedRows\": 951,\n                    \"size\": 278528\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31122753,\n        \"File\": \"20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20230919_100605_full18a2h_assoenvolefr_e40e037f07f9f9355270_20230919080605_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 92996191,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIG1hE5AQGneB0u0k9zvgatEb11sBoGGOcGtm42eXOmux-M5w\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1695110795,\n            \"stopped_timestamp\": 1695110853,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("102","20231004_020255_dble4a2h_assoenvolefr","133bc19cd375df6d2835_20231004000255","100","2023-10-04 02:02:55","unknown","{\n    \"ID\": 102,\n    \"Created\": \"2023-10-04 00:02:55\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.1\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231004_020255_dble4a2h_assoenvolefr\",\n    \"Hash\": \"133bc19cd375df6d2835_20231004000255\",\n    \"NameHash\": \"20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255_scan.json\",\n    \"timer_start\": 1696377776.396744,\n    \"Runtime\": \"9.706 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.86MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5095189,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"WLtQT4XGyl4WdAJ5S7YSGW9G3tZTM0NVovHN0JypK4FUimc9\\/+a2q7XckJ02a0UGTPdaIqPRxeasRockM874rQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25537,\n            \"tablesSizeOnDisk\": 46792704,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": 10,\n                    \"size\": 180224\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 218,\n                    \"insertedRows\": 238,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4340,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1167,\n                    \"insertedRows\": 1230,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 179,\n                    \"insertedRows\": 179,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1228,\n                    \"insertedRows\": 1231,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 29,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6540,\n                    \"insertedRows\": 6853,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1734,\n                    \"insertedRows\": 1898,\n                    \"size\": 2375680\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6837,\n                    \"insertedRows\": 6853,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2010,\n                    \"insertedRows\": 2019,\n                    \"size\": 1212416\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 262144\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30585773,\n        \"File\": \"20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231004_020255_dble4a2h_assoenvolefr_133bc19cd375df6d2835_20231004000255_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5095189,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIG5COAUjSWblIUmYZBEVkh2hJab7z1_AvkqurPf37pQ1QBzQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1696377786,\n            \"stopped_timestamp\": 1696377793,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("103","20231018_021205_full18a2h_assoenvolefr","e103bb147ba03b227023_20231018001205","-1","2023-10-18 02:12:06","unknown","{\n    \"ID\": 103,\n    \"Created\": \"2023-10-18 00:12:05\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231018_021205_full18a2h_assoenvolefr\",\n    \"Hash\": \"e103bb147ba03b227023_20231018001205\",\n    \"NameHash\": \"20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205_scan.json\",\n    \"timer_start\": 1697587932.984048,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 178678991,\n        \"Dirs\": null,\n        \"DirCount\": 1015,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6840,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"iUpYiQJOX3AP1OudrBaCm+WiSdSgZ9bw3Lqa0eoQ3IQu2XhxA8TSk\\/\\/NY3AMnK9h0rOokxnUSdAhqRLh3GLoXQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20370,\n            \"tablesSizeOnDisk\": 45711360,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": 11,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 206,\n                    \"insertedRows\": 209,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4352,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1167,\n                    \"insertedRows\": 1232,\n                    \"size\": 31866880\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 179,\n                    \"insertedRows\": 179,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1465,\n                    \"insertedRows\": 1433,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 4,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 1205,\n                    \"insertedRows\": 6854,\n                    \"size\": 1589248\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1844,\n                    \"insertedRows\": 1898,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6608,\n                    \"insertedRows\": 6854,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2060,\n                    \"insertedRows\": 2002,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 1231,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30584474,\n        \"File\": \"20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231018_021205_full18a2h_assoenvolefr_e103bb147ba03b227023_20231018001205_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("104","20231020_151809_full18a2h_assoenvolefr","f7865d1e476b9e691216_20231020131809","100","2023-10-20 15:18:09","webadmin","{\n    \"ID\": 104,\n    \"Created\": \"2023-10-20 13:18:09\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231020_151809_full18a2h_assoenvolefr\",\n    \"Hash\": \"f7865d1e476b9e691216_20231020131809\",\n    \"NameHash\": \"20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809_scan.json\",\n    \"timer_start\": 1697807898.07529,\n    \"Runtime\": \"29.973 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"92.91MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97423706,\n        \"Dirs\": null,\n        \"DirCount\": 1015,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6840,\n        \"file_count\": 7856,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"kKk6NFeBD3n6T\\/q2pRGtwHeuyFkMTHvkT1bDzh9RRaW8nB8JBvhF3WhNY1BDzq2TnK7\\/4KGk6MRMydMtkWFoxw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25910,\n            \"tablesSizeOnDisk\": 48889856,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 12,\n                    \"insertedRows\": 12,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 307,\n                    \"insertedRows\": 392,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4355,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1115,\n                    \"insertedRows\": 1235,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1392,\n                    \"insertedRows\": 1368,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 16,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6628,\n                    \"insertedRows\": 6854,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1712,\n                    \"insertedRows\": 1927,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6850,\n                    \"insertedRows\": 6854,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2086,\n                    \"insertedRows\": 2047,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31623444,\n        \"File\": \"20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231020_151809_full18a2h_assoenvolefr_f7865d1e476b9e691216_20231020131809_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97423706,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIG9Yl-b4lVgCGz8Stk66NS-ptj_oWuxO82mZH1sMpRlw4wKg\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1697807928,\n            \"stopped_timestamp\": 1697807998,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("105","20231020_152013_dble4a2h_assoenvolefr","ddfe58b7417f0a101814_20231020132013","100","2023-10-20 15:20:13","webadmin","{\n    \"ID\": 105,\n    \"Created\": \"2023-10-20 13:20:13\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231020_152013_dble4a2h_assoenvolefr\",\n    \"Hash\": \"ddfe58b7417f0a101814_20231020132013\",\n    \"NameHash\": \"20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013_scan.json\",\n    \"timer_start\": 1697808013.627388,\n    \"Runtime\": \"6.493 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"5.02MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5267474,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"hA1qdX9UBhxgmiEhqxy0cJXcE7hb1eYQ7t6QHRz7HjMgAvME2ly7FRO6YZYYJY3Ua+CcO8kcFLiWFK\\/zmeCMmQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25910,\n            \"tablesSizeOnDisk\": 48889856,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 306,\n                    \"insertedRows\": 392,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4355,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1115,\n                    \"insertedRows\": 1235,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1392,\n                    \"insertedRows\": 1368,\n                    \"size\": 114688\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 16,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6628,\n                    \"insertedRows\": 6854,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1712,\n                    \"insertedRows\": 1927,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6850,\n                    \"insertedRows\": 6854,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2086,\n                    \"insertedRows\": 2047,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31644958,\n        \"File\": \"20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231020_152013_dble4a2h_assoenvolefr_ddfe58b7417f0a101814_20231020132013_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5267474,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIG9SkXUnpOU4GnGnav3uDgWNZhem3DIP2vJ2pkxsc5SFd_zg\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1697808020,\n            \"stopped_timestamp\": 1697808026,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("106","20231104_020008_dble4a2h_assoenvolefr","4150a052208c96556551_20231104010008","100","2023-11-04 02:00:08","unknown","{\n    \"ID\": 106,\n    \"Created\": \"2023-11-04 01:00:08\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231104_020008_dble4a2h_assoenvolefr\",\n    \"Hash\": \"4150a052208c96556551_20231104010008\",\n    \"NameHash\": \"20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008_scan.json\",\n    \"timer_start\": 1699059609.237077,\n    \"Runtime\": \"10.924 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.86MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5091937,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"nL2EJ5lmruQ+34OJkF+ONg6XU0+KQCv\\/Ft96edrTVS9b2dxm9w483Ep+7ezn0ZBS3lcEjs2Lp5C+7nGDgki9Mw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26065,\n            \"tablesSizeOnDisk\": 46809088,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 14,\n                    \"insertedRows\": 14,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 213,\n                    \"insertedRows\": 213,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4355,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1126,\n                    \"insertedRows\": 1233,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 1844,\n                    \"insertedRows\": 1844,\n                    \"size\": 163840\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6442,\n                    \"insertedRows\": 6858,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1640,\n                    \"insertedRows\": 1703,\n                    \"size\": 1277952\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6916,\n                    \"insertedRows\": 6859,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2051,\n                    \"insertedRows\": 2024,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 955,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30598623,\n        \"File\": \"20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231104_020008_dble4a2h_assoenvolefr_4150a052208c96556551_20231104010008_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5091937,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHAxuP3q39SS4TV4Uf7yfBGnhOF4jORU4B6OoSv0MlI1P7ew\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1699059620,\n            \"stopped_timestamp\": 1699059626,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("107","20231118_020147_full18a2h_assoenvolefr","2d4899ac7b93f11f7583_20231118010147","-1","2023-11-18 02:01:47","unknown","{\n    \"ID\": 107,\n    \"Created\": \"2023-11-18 01:01:47\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231118_020147_full18a2h_assoenvolefr\",\n    \"Hash\": \"2d4899ac7b93f11f7583_20231118010147\",\n    \"NameHash\": \"20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147_scan.json\",\n    \"timer_start\": 1700269313.870629,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 178971055,\n        \"Dirs\": null,\n        \"DirCount\": 1016,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6841,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"dYyJqgl5FZPAx1kJBGeeV\\/U+ZtALWkdSEMy4Z7lDg\\/vkrEUCle3kmLBUYNkuc2EIeJDWkNEKxH6SmFDl5NBDgw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27470,\n            \"tablesSizeOnDisk\": 47972352,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 14,\n                    \"insertedRows\": 15,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 594,\n                    \"insertedRows\": 598,\n                    \"size\": 2244608\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4357,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1115,\n                    \"insertedRows\": 1236,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2144,\n                    \"insertedRows\": 2145,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 65,\n                    \"insertedRows\": 66,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 6,\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6787,\n                    \"insertedRows\": 6860,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1840,\n                    \"insertedRows\": 1893,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6850,\n                    \"insertedRows\": 6860,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2264,\n                    \"insertedRows\": 2279,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 262144\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30730667,\n        \"File\": \"20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231118_020147_full18a2h_assoenvolefr_2d4899ac7b93f11f7583_20231118010147_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("108","20231123_141156_full18a2h_assoenvolefr","8b21798bd6c2650e7015_20231123131156","100","2023-11-23 14:11:56","cn099","{\n    \"ID\": 108,\n    \"Created\": \"2023-11-23 13:11:56\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231123_141156_full18a2h_assoenvolefr\",\n    \"Hash\": \"8b21798bd6c2650e7015_20231123131156\",\n    \"NameHash\": \"20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156_scan.json\",\n    \"timer_start\": 1700745120.653052,\n    \"Runtime\": \"14.291 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"93.04MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97554674,\n        \"Dirs\": null,\n        \"DirCount\": 1016,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6841,\n        \"file_count\": 7858,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"rvI+Ny+Y7mlG+Bz3hwMvIkWoU2XLCKxgZuiRPGCAcaKKEG\\/mEF2UAv23ihBHiyL5Pz+KUyazyH\\/BX\\/P5EiAntQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26259,\n            \"tablesSizeOnDisk\": 48988160,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 16,\n                    \"insertedRows\": 16,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 471,\n                    \"insertedRows\": 900,\n                    \"size\": 2244608\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4357,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1231,\n                    \"insertedRows\": 1236,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2295,\n                    \"insertedRows\": 2320,\n                    \"size\": 212992\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 11,\n                    \"insertedRows\": 22,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6088,\n                    \"insertedRows\": 6861,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1483,\n                    \"insertedRows\": 1961,\n                    \"size\": 2326528\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6837,\n                    \"insertedRows\": 6862,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2030,\n                    \"insertedRows\": 2100,\n                    \"size\": 1212416\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31370135,\n        \"File\": \"20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231123_141156_full18a2h_assoenvolefr_8b21798bd6c2650e7015_20231123131156_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97554674,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHF8R2pFLFiKLnPWHUELIvGZ6zwyH671o91iajPQ6Y0eMmew\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1700745135,\n            \"stopped_timestamp\": 1700745199,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("109","20231204_020007_dble4a2h_assoenvolefr","5f1fb3e2095b23eb1355_20231204010007","100","2023-12-04 02:00:07","unknown","{\n    \"ID\": 109,\n    \"Created\": \"2023-12-04 01:00:07\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231204_020007_dble4a2h_assoenvolefr\",\n    \"Hash\": \"5f1fb3e2095b23eb1355_20231204010007\",\n    \"NameHash\": \"20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007_scan.json\",\n    \"timer_start\": 1701651608.44679,\n    \"Runtime\": \"9.604 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5112133,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"X7G8oonMBBhLUqLDzOI1x5Yd7oLhIsQec7xjdcI9UPl2o1sz9\\/F26MlnBFQ3nGSNB7OS8K7Fv8AGP9weLHknFw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26389,\n            \"tablesSizeOnDisk\": 47890432,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 17,\n                    \"insertedRows\": 17,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 250,\n                    \"insertedRows\": 250,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4357,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1178,\n                    \"insertedRows\": 1235,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2300,\n                    \"insertedRows\": 2300,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 24,\n                    \"insertedRows\": 24,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 14,\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6221,\n                    \"insertedRows\": 6863,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1650,\n                    \"insertedRows\": 1843,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6824,\n                    \"insertedRows\": 6863,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2113,\n                    \"insertedRows\": 2051,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 955,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30711857,\n        \"File\": \"20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231204_020007_dble4a2h_assoenvolefr_5f1fb3e2095b23eb1355_20231204010007_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5112133,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHIcexsrJYZyvVVtCRI-pBlgJ1Oq4mlAS8yObjRoShcXDSGQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1701651618,\n            \"stopped_timestamp\": 1701651626,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("110","20231218_020225_full18a2h_assoenvolefr","5adbf7bf30f0d6833913_20231218010225","100","2023-12-18 02:02:25","unknown","{\n    \"ID\": 110,\n    \"Created\": \"2023-12-18 01:02:25\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20231218_020225_full18a2h_assoenvolefr\",\n    \"Hash\": \"5adbf7bf30f0d6833913_20231218010225\",\n    \"NameHash\": \"20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225_scan.json\",\n    \"timer_start\": 1702861352.608586,\n    \"Runtime\": \"15.739 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"92.91MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97427921,\n        \"Dirs\": null,\n        \"DirCount\": 1017,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6841,\n        \"file_count\": 7859,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"KQRq3ZE6majQScsBia7ryDvAEXB1gANvLLYPLG+lzCzCPiVgKnEByl9CJ4EkM0eAfT+thgY3\\/obC6u4HwQIlHQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26567,\n            \"tablesSizeOnDisk\": 47890432,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 17,\n                    \"insertedRows\": 18,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 261,\n                    \"insertedRows\": 263,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4357,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1115,\n                    \"insertedRows\": 1235,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2318,\n                    \"insertedRows\": 2319,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 86,\n                    \"insertedRows\": 87,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 20,\n                    \"insertedRows\": 20,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6557,\n                    \"insertedRows\": 6863,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1625,\n                    \"insertedRows\": 1764,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6749,\n                    \"insertedRows\": 6864,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2024,\n                    \"insertedRows\": 2044,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30620832,\n        \"File\": \"20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20231218_020225_full18a2h_assoenvolefr_5adbf7bf30f0d6833913_20231218010225_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97427921,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHL7YSGGz11EvalQlv7XeheQT5N1sRsMrBsbUOoQuOXwQhlQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1702861368,\n            \"stopped_timestamp\": 1702861436,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("111","20240104_020805_dble4a2h_assoenvolefr","5032b4729f50982d1906_20240104010805","100","2024-01-04 02:08:05","unknown","{\n    \"ID\": 111,\n    \"Created\": \"2024-01-04 01:08:05\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240104_020805_dble4a2h_assoenvolefr\",\n    \"Hash\": \"5032b4729f50982d1906_20240104010805\",\n    \"NameHash\": \"20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805_scan.json\",\n    \"timer_start\": 1704330486.074975,\n    \"Runtime\": \"7.742 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5114558,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"dSJmWqSGzubeeEHLbbe2Tt\\/W14q1bNQDQKqjviptuGnw\\/97WmtkVX3Dw1V9ckdyHCukt88+XxWTEi+Q4eOTatg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27384,\n            \"tablesSizeOnDisk\": 49004544,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 19,\n                    \"insertedRows\": 19,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 276,\n                    \"insertedRows\": 278,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4297,\n                    \"insertedRows\": 4357,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1180,\n                    \"insertedRows\": 1235,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2656,\n                    \"insertedRows\": 2656,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 58,\n                    \"insertedRows\": 58,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6433,\n                    \"insertedRows\": 6864,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1713,\n                    \"insertedRows\": 1841,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6908,\n                    \"insertedRows\": 6865,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2046,\n                    \"insertedRows\": 2061,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 1246,\n                    \"insertedRows\": 1246,\n                    \"size\": 278528\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30860073,\n        \"File\": \"20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240104_020805_dble4a2h_assoenvolefr_5032b4729f50982d1906_20240104010805_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5114558,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHQCKcVFGNpIMtOKPYR_PWysdixLzL1ftnq1GIm0dD_dbawg\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1704330494,\n            \"stopped_timestamp\": 1704330500,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("112","20240118_022258_full18a2h_assoenvolefr","11bba4d1f4824d2d4331_20240118012258","-1","2024-01-18 02:22:58","unknown","{\n    \"ID\": 112,\n    \"Created\": \"2024-01-18 01:22:58\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240118_022258_full18a2h_assoenvolefr\",\n    \"Hash\": \"11bba4d1f4824d2d4331_20240118012258\",\n    \"NameHash\": \"20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258_scan.json\",\n    \"timer_start\": 1705540987.207974,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 179210102,\n        \"Dirs\": null,\n        \"DirCount\": 1019,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6843,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"fDsHmfydLzhvrqgQziaZWupTIYZpXGvSyzJz6dKOWOTogg5M0TgmRfNuHTAp5i9Wg2eprT+n\\/tC94jJn8jl3Ug==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26700,\n            \"tablesSizeOnDisk\": 48955392,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 19,\n                    \"insertedRows\": 20,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 217,\n                    \"insertedRows\": 219,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4360,\n                    \"insertedRows\": 4369,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1178,\n                    \"insertedRows\": 1240,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2455,\n                    \"insertedRows\": 2457,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 12,\n                    \"insertedRows\": 12,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6406,\n                    \"insertedRows\": 6865,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1836,\n                    \"insertedRows\": 1888,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6661,\n                    \"insertedRows\": 6866,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2047,\n                    \"insertedRows\": 2010,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 955,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30823248,\n        \"File\": \"20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240118_022258_full18a2h_assoenvolefr_11bba4d1f4824d2d4331_20240118012258_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("113","20240124_144935_dble4a2h_assoenvolefr","96f992f0550adaea3350_20240124134935","100","2024-01-24 14:49:35","webadmin","{\n    \"ID\": 113,\n    \"Created\": \"2024-01-24 13:49:35\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240124_144935_dble4a2h_assoenvolefr\",\n    \"Hash\": \"96f992f0550adaea3350_20240124134935\",\n    \"NameHash\": \"20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935_scan.json\",\n    \"timer_start\": 1706104175.93212,\n    \"Runtime\": \"15.132 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5112610,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ZvLegBeABrZanDDQGYTJDfgKsJk9VOyrqsl74uBZDLADdaoD+gH2lvL8CmlpyFkWDVOHhKNOAcQnboEc7iVQ\\/w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26605,\n            \"tablesSizeOnDisk\": 47890432,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 21,\n                    \"insertedRows\": 21,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 308,\n                    \"insertedRows\": 516,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4360,\n                    \"insertedRows\": 4369,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1180,\n                    \"insertedRows\": 1241,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2243,\n                    \"insertedRows\": 2201,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 16,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6497,\n                    \"insertedRows\": 6868,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1675,\n                    \"insertedRows\": 1849,\n                    \"size\": 2342912\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6859,\n                    \"insertedRows\": 6868,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 1944,\n                    \"insertedRows\": 2015,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30868890,\n        \"File\": \"20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240124_144935_dble4a2h_assoenvolefr_96f992f0550adaea3350_20240124134935_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5112610,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHVRBvKS55ysjMPoIeoUdfZYPnqqM8-OzAFplU11xgctMAyw\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1706104191,\n            \"stopped_timestamp\": 1706104204,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("114","20240124_145011_full18a2h_assoenvolefr","dcbadd18db887c5e9592_20240124135011","100","2024-01-24 14:50:11","webadmin","{\n    \"ID\": 114,\n    \"Created\": \"2024-01-24 13:50:11\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240124_145011_full18a2h_assoenvolefr\",\n    \"Hash\": \"dcbadd18db887c5e9592_20240124135011\",\n    \"NameHash\": \"20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011_scan.json\",\n    \"timer_start\": 1706104216.934464,\n    \"Runtime\": \"28.282 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"93.1MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97625263,\n        \"Dirs\": null,\n        \"DirCount\": 1019,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6842,\n        \"file_count\": 7862,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"+XqS0Sh1qgGoNRms0MOY7LOQZmd67Q2XQUAqAZpUiI1bVrE4CbnDcqh8eQ7deZFianpmbUiF6LIoKie4To\\/CXg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26600,\n            \"tablesSizeOnDisk\": 47890432,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 22,\n                    \"insertedRows\": 22,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 302,\n                    \"insertedRows\": 516,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4360,\n                    \"insertedRows\": 4369,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1180,\n                    \"insertedRows\": 1241,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2243,\n                    \"insertedRows\": 2201,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 16,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 10,\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6497,\n                    \"insertedRows\": 6868,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1675,\n                    \"insertedRows\": 1849,\n                    \"size\": 2342912\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6859,\n                    \"insertedRows\": 6868,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 1944,\n                    \"insertedRows\": 2015,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30887744,\n        \"File\": \"20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240124_145011_full18a2h_assoenvolefr_dcbadd18db887c5e9592_20240124135011_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97625263,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHVX1zTY5dDPt5sGX5r4Tq4i59jcSrBLwp2kYRybKktUFiIg\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1706104245,\n            \"stopped_timestamp\": 1706104309,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("115","20240204_020205_dble4a2h_assoenvolefr","135d0ab316f7c3794366_20240204010205","100","2024-02-04 02:02:05","unknown","{\n    \"ID\": 115,\n    \"Created\": \"2024-02-04 01:02:05\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.3\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240204_020205_dble4a2h_assoenvolefr\",\n    \"Hash\": \"135d0ab316f7c3794366_20240204010205\",\n    \"NameHash\": \"20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205_scan.json\",\n    \"timer_start\": 1707008525.909122,\n    \"Runtime\": \"8.139 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.89MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5125108,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"iJnrblmlyo89PupRpdtbIIQouUl3pAPnTgcZSjsjAxEnltTuICWIASj538nqXxyLr8HecuVY8ZjOCCJ5TvFGaw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27929,\n            \"tablesSizeOnDisk\": 46891008,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 450,\n                    \"insertedRows\": 454,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4358,\n                    \"insertedRows\": 4368,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1191,\n                    \"insertedRows\": 1238,\n                    \"size\": 31883264\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2266,\n                    \"insertedRows\": 2266,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 58,\n                    \"insertedRows\": 58,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 11,\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 7360,\n                    \"insertedRows\": 6870,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1805,\n                    \"insertedRows\": 2018,\n                    \"size\": 1327104\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6771,\n                    \"insertedRows\": 6870,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2142,\n                    \"insertedRows\": 2190,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30869925,\n        \"File\": \"20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240204_020205_dble4a2h_assoenvolefr_135d0ab316f7c3794366_20240204010205_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5125108,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHXxMKKmO7Dbl_uYOx8zHpeUxHS0Mdg-fHr_1c5TS9J2OleA\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1707008534,\n            \"stopped_timestamp\": 1707008540,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("116","20240218_020121_full18a2h_assoenvolefr","73eeb9c5bbce5b343234_20240218010121","100","2024-02-18 02:01:22","unknown","{\n    \"ID\": 116,\n    \"Created\": \"2024-02-18 01:01:21\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.3\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240218_020121_full18a2h_assoenvolefr\",\n    \"Hash\": \"73eeb9c5bbce5b343234_20240218010121\",\n    \"NameHash\": \"20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121_scan.json\",\n    \"timer_start\": 1708218089.186249,\n    \"Runtime\": \"80.551 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"93.25MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97781907,\n        \"Dirs\": null,\n        \"DirCount\": 1020,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6844,\n        \"file_count\": 7865,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"Veyudkx7dCfjYfsWIFtX8Db25mzjL4xD6xvF25p2u9ezajZcypme6kGCd1ZQt3vaJNn2ZxckwegzeLrX3gJokA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27946,\n            \"tablesSizeOnDisk\": 47988736,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 24,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 437,\n                    \"insertedRows\": 439,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4358,\n                    \"insertedRows\": 4390,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1170,\n                    \"insertedRows\": 1242,\n                    \"size\": 32931840\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2357,\n                    \"insertedRows\": 2358,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 70,\n                    \"insertedRows\": 71,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 12,\n                    \"insertedRows\": 12,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6630,\n                    \"insertedRows\": 6872,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1830,\n                    \"insertedRows\": 1825,\n                    \"size\": 1343488\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 7084,\n                    \"insertedRows\": 6872,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2182,\n                    \"insertedRows\": 2190,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 1248,\n                    \"insertedRows\": 1248,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30751044,\n        \"File\": \"20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240218_020121_full18a2h_assoenvolefr_73eeb9c5bbce5b343234_20240218010121_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97781907,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHbQm_gJtLjWirWrpcj9m2FWPgg2vanl0x2hHz2XnriJgGog\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1708218169,\n            \"stopped_timestamp\": 1708218241,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("117","20240304_020715_dble4a2h_assoenvolefr","62528aa33ac41afd7488_20240304010715","100","2024-03-04 02:07:15","unknown","{\n    \"ID\": 117,\n    \"Created\": \"2024-03-04 01:07:15\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.3\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240304_020715_dble4a2h_assoenvolefr\",\n    \"Hash\": \"62528aa33ac41afd7488_20240304010715\",\n    \"NameHash\": \"20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715_scan.json\",\n    \"timer_start\": 1709514436.659687,\n    \"Runtime\": \"7.332 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5121049,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"AdoC5w6yGoC+JN9f5h\\/ni7W7bpK9PQ8uEYkFl0LjHRePlDFPPtx9jCjuEau8IMZmumFOV58dmq0z2qYDuYAoYA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28082,\n            \"tablesSizeOnDisk\": 47939584,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 25,\n                    \"insertedRows\": 25,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 391,\n                    \"insertedRows\": 390,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4358,\n                    \"insertedRows\": 4390,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1218,\n                    \"insertedRows\": 1242,\n                    \"size\": 32931840\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2477,\n                    \"insertedRows\": 2478,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 56,\n                    \"insertedRows\": 57,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 11,\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 7093,\n                    \"insertedRows\": 6874,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1675,\n                    \"insertedRows\": 1694,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6798,\n                    \"insertedRows\": 6874,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2188,\n                    \"insertedRows\": 2182,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 1247,\n                    \"insertedRows\": 1247,\n                    \"size\": 278528\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30807676,\n        \"File\": \"20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240304_020715_dble4a2h_assoenvolefr_62528aa33ac41afd7488_20240304010715_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5121049,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHfDVFc5COccdiqFvVh6mI8h5TFkf6nj8h1JBTZ_nxzmEJUw\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1709514444,\n            \"stopped_timestamp\": 1709514452,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("118","20240318_020401_full18a2h_assoenvolefr","74ac91071e8224a84719_20240318010401","100","2024-03-18 02:04:01","unknown","{\n    \"ID\": 118,\n    \"Created\": \"2024-03-18 01:04:01\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.3\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240318_020401_full18a2h_assoenvolefr\",\n    \"Hash\": \"74ac91071e8224a84719_20240318010401\",\n    \"NameHash\": \"20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401_scan.json\",\n    \"timer_start\": 1710723848.137709,\n    \"Runtime\": \"34.684 sec.\",\n    \"ExeSize\": \"128.53KB\",\n    \"ZipSize\": \"93.35MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 97883421,\n        \"Dirs\": null,\n        \"DirCount\": 1021,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 6844,\n        \"file_count\": 7866,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401_installer.php\",\n        \"Size\": 131614,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"dKfx9pFEGIKvDi9uhFAk\\/SwjHHuDA4XSBXbSAwUeKDxrRbHzEElli7EKcbLtuLvv2dL90THW\\/IV674+UO+3kVw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25646,\n            \"tablesSizeOnDisk\": 48922624,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 25,\n                    \"insertedRows\": 26,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 299,\n                    \"insertedRows\": 305,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4358,\n                    \"insertedRows\": 4418,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1170,\n                    \"insertedRows\": 1246,\n                    \"size\": 32931840\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2493,\n                    \"insertedRows\": 2494,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 31,\n                    \"insertedRows\": 31,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 21,\n                    \"insertedRows\": 21,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 5464,\n                    \"insertedRows\": 6875,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1597,\n                    \"insertedRows\": 1663,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6626,\n                    \"insertedRows\": 6875,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 2063,\n                    \"insertedRows\": 2078,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 955,\n                    \"insertedRows\": 955,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 31234548,\n        \"File\": \"20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240318_020401_full18a2h_assoenvolefr_74ac91071e8224a84719_20240318010401_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 97883421,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHig8vMx1enRcHIDBoCA81RoebV0GUek2Fux-X4UR7SOeSJQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1710723883,\n            \"stopped_timestamp\": 1710723949,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("119","20240404_021120_dble4a2h_assoenvolefr","a49ae12c01407d2b2130_20240404001120","100","2024-04-04 02:11:20","unknown","{\n    \"ID\": 119,\n    \"Created\": \"2024-04-04 00:11:20\",\n    \"Version\": \"4.5.12.1\",\n    \"VersionWP\": \"6.3.3\",\n    \"VersionDB\": \"5.7.42\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240404_021120_dble4a2h_assoenvolefr\",\n    \"Hash\": \"a49ae12c01407d2b2130_20240404001120\",\n    \"NameHash\": \"20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120_scan.json\",\n    \"timer_start\": 1712189481.612882,\n    \"Runtime\": \"8.485 sec.\",\n    \"ExeSize\": \"128.52KB\",\n    \"ZipSize\": \"4.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5119739,\n        \"Dirs\": null,\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120_installer.php\",\n        \"Size\": 131605,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"KRk3DEhev47h\\/TgDTuPojzcDC5g7ZeYRi6BIQzqtjnnoo0m3WdvlnzLpvs0OLE2AAfRUpL987XCrfFWg4cITTA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 26752,\n            \"tablesSizeOnDisk\": 47906816,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 32768\n                },\n                \"pp5_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": 27,\n                    \"size\": 1228800\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": 279,\n                    \"insertedRows\": 292,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": 4358,\n                    \"insertedRows\": 4420,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": 1207,\n                    \"insertedRows\": 1246,\n                    \"size\": 32931840\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": 13,\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": 15,\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": 180,\n                    \"insertedRows\": 180,\n                    \"size\": 49152\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": 2564,\n                    \"insertedRows\": 2580,\n                    \"size\": 212992\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 49,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": 270,\n                    \"insertedRows\": 272,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": 11,\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": 6541,\n                    \"insertedRows\": 6876,\n                    \"size\": 3686400\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": 1674,\n                    \"insertedRows\": 1670,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": 6657,\n                    \"insertedRows\": 6876,\n                    \"size\": 1589248\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": 1921,\n                    \"insertedRows\": 2101,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": 30,\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": 947,\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"5.7.42\",\n            \"versionComment\": \"MySQL Community Server (GPL)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 30795117,\n        \"File\": \"20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server (GPL)\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240404_021120_dble4a2h_assoenvolefr_a49ae12c01407d2b2130_20240404001120_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"6\",\n            \"archive_offset\": 5119739,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": \"pid_upload_session:ABIHm6VJ5VXBHmwnesfBsgWMYE2ujXdPqB2HnsP4cBHV6aPHyQ\",\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1712189490,\n            \"stopped_timestamp\": 1712189497,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": \"6\",\n    \"template_id\": -1\n}","","0","","","2024-04-14 12:18:26"),
("120","20240418_023352_full18a2h_assoenvolefr","30b113e8d9be9b488192_20240418003352","-1","2024-04-18 00:33:52","unknown","{\n    \"ID\": 120,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240418_023352_full18a2h_assoenvolefr\",\n    \"Hash\": \"30b113e8d9be9b488192_20240418003352\",\n    \"NameHash\": \"20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_scan.json\",\n    \"timer_start\": 1713400440.869772,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 191636741,\n        \"Dirs\": [],\n        \"DirCount\": 1243,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7705,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"fsKq\\/CJBgYc0EmOBxp4WYJ9MB0SslyITSfc0K07ze56R32qhDcF+n1C6FHBlT7vYYv21RIjO3gNTAaG62ucdaw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28667,\n            \"tablesSizeOnDisk\": 51740672,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 28,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"286\",\n                    \"insertedRows\": 307,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4482\",\n                    \"insertedRows\": 4442,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1177\",\n                    \"insertedRows\": 1270,\n                    \"size\": 32948224\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2357\",\n                    \"insertedRows\": 2309,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 27,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7508\",\n                    \"insertedRows\": 7740,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1729\",\n                    \"insertedRows\": 1900,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7495\",\n                    \"insertedRows\": 7740,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2068\",\n                    \"insertedRows\": 2055,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"951\",\n                    \"insertedRows\": 1303,\n                    \"size\": 262144\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33007356,\n        \"File\": \"20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-04-18 00:33:52\",\n    \"updated\": \"2024-04-18 00:34:12\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240418_023352_full18a2h_assoenvolefr_30b113e8d9be9b488192_20240418003352_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.16.4","2024-04-18 00:34:12"),
("121","20240429_150024_full18a2h_assoenvolefr","f1bfbacb981a5bd52568_20240429130024","100","2024-04-29 13:00:24","unknown","{\n    \"ID\": 121,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240429_150024_full18a2h_assoenvolefr\",\n    \"Hash\": \"f1bfbacb981a5bd52568_20240429130024\",\n    \"NameHash\": \"20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_scan.json\",\n    \"timer_start\": 1714395632.070459,\n    \"Runtime\": \"35.464 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.5MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105385733,\n        \"Dirs\": [],\n        \"DirCount\": 1243,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7709,\n        \"file_count\": 8953,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"FEq2KFP\\/95Gep1Pk9Wjq2VISbXtPPFDvrmHb79xxiSwxP1HJX0NtbVOEoXRhSaPs8SAjh8Tl+0h2Dr02tGhszA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29237,\n            \"tablesSizeOnDisk\": 50659328,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 29,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"354\",\n                    \"insertedRows\": 652,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4346\",\n                    \"insertedRows\": 4463,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1201\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 182,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2166\",\n                    \"insertedRows\": 2172,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 16,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7941\",\n                    \"insertedRows\": 7746,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1618\",\n                    \"insertedRows\": 1708,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7939\",\n                    \"insertedRows\": 7746,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 162,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2076\",\n                    \"insertedRows\": 2041,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33488075,\n        \"File\": \"20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 83.58404894633122,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714395667,\n            \"stopped_timestamp\": 1714395750,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-04-29 13:00:24\",\n    \"updated\": \"2024-04-29 13:02:30\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240429_150024_full18a2h_assoenvolefr_f1bfbacb981a5bd52568_20240429130024_archive.zip","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-04-29 13:02:30");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("122","20240504_020531_dble4a2h_assoenvolefr","19027520a38a9d546661_20240504000531","100","2024-05-04 00:05:31","unknown","{\n    \"ID\": 122,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240504_020531_dble4a2h_assoenvolefr\",\n    \"Hash\": \"19027520a38a9d546661_20240504000531\",\n    \"NameHash\": \"20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_scan.json\",\n    \"timer_start\": 1714781132.285068,\n    \"Runtime\": \"9.064 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.45MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5716966,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"YpCF3oYAR3ZFHf9MqhgHGKGB091JfUMFQ+qf3LiZfLYvLVAvD7WbCarEjdYWn3HuZqrtwbQ54IW2TH5xaQLksQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30096,\n            \"tablesSizeOnDisk\": 51757056,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"528\",\n                    \"insertedRows\": 202,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4520\",\n                    \"insertedRows\": 4463,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1300\",\n                    \"insertedRows\": 1275,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1969\",\n                    \"insertedRows\": 1945,\n                    \"size\": 163840\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"8229\",\n                    \"insertedRows\": 7746,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1746\",\n                    \"insertedRows\": 1793,\n                    \"size\": 2342912\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7687\",\n                    \"insertedRows\": 7746,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2154\",\n                    \"insertedRows\": 2000,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1306\",\n                    \"insertedRows\": 947,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 32973140,\n        \"File\": \"20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714781141,\n            \"stopped_timestamp\": 1714781149,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-05-04 00:05:31\",\n    \"updated\": \"2024-05-04 00:05:49\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240504_020531_dble4a2h_assoenvolefr_19027520a38a9d546661_20240504000531_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-05-04 00:05:49"),
("123","20240518_020154_full18a2h_assoenvolefr","7ea6ea87dcf2d8b48139_20240518000154","100","2024-05-18 00:01:54","unknown","{\n    \"ID\": 123,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240518_020154_full18a2h_assoenvolefr\",\n    \"Hash\": \"7ea6ea87dcf2d8b48139_20240518000154\",\n    \"NameHash\": \"20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_scan.json\",\n    \"timer_start\": 1715990521.638008,\n    \"Runtime\": \"236.309 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.77MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105666983,\n        \"Dirs\": [],\n        \"DirCount\": 1244,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7711,\n        \"file_count\": 8956,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"Sqn0AETt\\/pcFGByIUPlgFSzzodDS022ejua4uLBknlnJQBCKV0r1YGslDJ0fcINZH8z48e7M+PhnxqFV8dNHBQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28718,\n            \"tablesSizeOnDisk\": 50708480,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 31,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"384\",\n                    \"insertedRows\": 372,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4489\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1071\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2218\",\n                    \"insertedRows\": 2337,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"66\",\n                    \"insertedRows\": 84,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7519\",\n                    \"insertedRows\": 7750,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1879\",\n                    \"insertedRows\": 2025,\n                    \"size\": 1343488\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7425\",\n                    \"insertedRows\": 7750,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2115\",\n                    \"insertedRows\": 2101,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 1310,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33062895,\n        \"File\": \"20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.16909510930469,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715990758,\n            \"stopped_timestamp\": 1715990825,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-05-18 00:01:54\",\n    \"updated\": \"2024-05-18 00:07:05\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240518_020154_full18a2h_assoenvolefr_7ea6ea87dcf2d8b48139_20240518000154_archive.zip","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-05-18 00:07:05"),
("124","20240604_020939_dble4a2h_assoenvolefr","cf51c3f5b9273e0b3384_20240604000939","100","2024-06-04 00:09:39","unknown","{\n    \"ID\": 124,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240604_020939_dble4a2h_assoenvolefr\",\n    \"Hash\": \"cf51c3f5b9273e0b3384_20240604000939\",\n    \"NameHash\": \"20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_scan.json\",\n    \"timer_start\": 1717459780.348471,\n    \"Runtime\": \"9.562 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.48MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5748654,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Z7qnB\\/fzbl2lJvYIFTS03o2QYLQJ4YNR8UxKUihNUu2CBLDN0mjOvnH9\\/RqSVX1ruGxPc3FBYTZ8Z\\/bADxZDSg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30147,\n            \"tablesSizeOnDisk\": 51757056,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 32,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 318,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4674\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1062\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2671\",\n                    \"insertedRows\": 2692,\n                    \"size\": 245760\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 59,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"8013\",\n                    \"insertedRows\": 7750,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1937\",\n                    \"insertedRows\": 1987,\n                    \"size\": 2375680\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7912\",\n                    \"insertedRows\": 7750,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2031\",\n                    \"insertedRows\": 2089,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"947\",\n                    \"insertedRows\": 955,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33196173,\n        \"File\": \"20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1717459790,\n            \"stopped_timestamp\": 1717459797,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-06-04 00:09:39\",\n    \"updated\": \"2024-06-04 00:09:58\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240604_020939_dble4a2h_assoenvolefr_cf51c3f5b9273e0b3384_20240604000939_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-06-04 00:09:58"),
("125","20240618_020120_full18a2h_assoenvolefr","9740a06b8b5a11959363_20240618000120","-1","2024-06-18 00:01:20","unknown","{\n    \"ID\": 125,\n    \"VersionWP\": \"6.5.4\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240618_020120_full18a2h_assoenvolefr\",\n    \"Hash\": \"9740a06b8b5a11959363_20240618000120\",\n    \"NameHash\": \"20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_scan.json\",\n    \"timer_start\": 1718668888.03741,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 193186926,\n        \"Dirs\": [],\n        \"DirCount\": 1245,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7712,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"JAoaWuHLTVzP\\/nBOXXQy818OQwWRryNsrUzcVNU6xB7KOPg+m8rUcnohuZcd\\/pgi1ZXaZJtErGqVrBB+FsTfeQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29374,\n            \"tablesSizeOnDisk\": 51838976,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 33,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"412\",\n                    \"insertedRows\": 363,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4362\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1122\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2540\",\n                    \"insertedRows\": 2511,\n                    \"size\": 229376\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 50,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7462\",\n                    \"insertedRows\": 7751,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1599\",\n                    \"insertedRows\": 1827,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7827\",\n                    \"insertedRows\": 7751,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2097\",\n                    \"insertedRows\": 2138,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1317\",\n                    \"insertedRows\": 947,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33237302,\n        \"File\": \"20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-06-18 00:01:20\",\n    \"updated\": \"2024-06-18 00:01:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240618_020120_full18a2h_assoenvolefr_9740a06b8b5a11959363_20240618000120_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.16.4","2024-06-18 00:01:59"),
("126","20240619_145942_full18a2h_assoenvolefr","d88bae9279e056318025_20240619125942","-1","2024-06-19 12:59:42","unknown","{\n    \"ID\": 126,\n    \"VersionWP\": \"6.5.4\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240619_145942_full18a2h_assoenvolefr\",\n    \"Hash\": \"d88bae9279e056318025_20240619125942\",\n    \"NameHash\": \"20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_scan.json\",\n    \"timer_start\": 1718801987.062213,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 193176347,\n        \"Dirs\": [],\n        \"DirCount\": 1245,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7711,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"jd8Yoeuepn6b1IgjaKPNINp1o5t0uO7ZOdm+3EMuvT6J74ryAbeDATkjhKuLCnWwjlyTmEWWbkRdOV\\/Vv6MXSA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29116,\n            \"tablesSizeOnDisk\": 51773440,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 34,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"424\",\n                    \"insertedRows\": 624,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4466\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1372\",\n                    \"insertedRows\": 1277,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2434\",\n                    \"insertedRows\": 2353,\n                    \"size\": 212992\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 9,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7308\",\n                    \"insertedRows\": 7751,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1943\",\n                    \"insertedRows\": 1758,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7404\",\n                    \"insertedRows\": 7751,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2143\",\n                    \"insertedRows\": 2034,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"956\",\n                    \"insertedRows\": 964,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33571998,\n        \"File\": \"20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-06-19 12:59:42\",\n    \"updated\": \"2024-06-19 13:00:03\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240619_145942_full18a2h_assoenvolefr_d88bae9279e056318025_20240619125942_archive.zip","-1","SCHEDULE_RUN_NOW,ZIP_ARCHIVE","4.5.16.4","2024-06-19 13:00:03"),
("127","20240619_150233_full18a2h_assoenvolefr","5b7cd14cf022037d9946_20240619130233","100","2024-06-19 13:02:33","unknown","{\n    \"ID\": 127,\n    \"VersionWP\": \"6.5.4\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240619_150233_full18a2h_assoenvolefr\",\n    \"Hash\": \"5b7cd14cf022037d9946_20240619130233\",\n    \"NameHash\": \"20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_scan.json\",\n    \"timer_start\": 1718802156.143094,\n    \"Runtime\": \"15.463 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.86MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105763587,\n        \"Dirs\": [],\n        \"DirCount\": 1245,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7711,\n        \"file_count\": 8957,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"rWAnG+AFb19+E+pMD\\/pgVOzN3NZxrgq4FsAtkSCuLbpUnvwGrgdUkBvdR47ZMZyLAjgxjv5C2h2DVGoL8Ds+uw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29116,\n            \"tablesSizeOnDisk\": 51773440,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 35,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"424\",\n                    \"insertedRows\": 626,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4466\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1372\",\n                    \"insertedRows\": 1277,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2434\",\n                    \"insertedRows\": 2353,\n                    \"size\": 212992\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 9,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7308\",\n                    \"insertedRows\": 7751,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1943\",\n                    \"insertedRows\": 1786,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7404\",\n                    \"insertedRows\": 7751,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2143\",\n                    \"insertedRows\": 2034,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"956\",\n                    \"insertedRows\": 964,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33647427,\n        \"File\": \"20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.087749940158,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1718802171,\n            \"stopped_timestamp\": 1718802239,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-06-19 13:02:33\",\n    \"updated\": \"2024-06-19 13:03:59\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240619_150233_full18a2h_assoenvolefr_5b7cd14cf022037d9946_20240619130233_archive.zip","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-06-19 13:03:59"),
("128","20240704_022740_dble4a2h_assoenvolefr","94f8dddf2147c1df7374_20240704002740","100","2024-07-04 00:27:40","unknown","{\n    \"ID\": 128,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240704_022740_dble4a2h_assoenvolefr\",\n    \"Hash\": \"94f8dddf2147c1df7374_20240704002740\",\n    \"NameHash\": \"20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_scan.json\",\n    \"timer_start\": 1720052861.743732,\n    \"Runtime\": \"12.117 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.48MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5743509,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"lgE6FYlxH+qTCsVNHC\\/7S21oyMSjuNzhkDHasjXBke7uljfyFBLUTEYg5InSEVzNI0ZnR7ucFJmjJXEwTa\\/9fw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28363,\n            \"tablesSizeOnDisk\": 51773440,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 36,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"458\",\n                    \"insertedRows\": 244,\n                    \"size\": 1196032\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4253\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1210\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2076\",\n                    \"insertedRows\": 2047,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"68\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 12,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"6942\",\n                    \"insertedRows\": 7754,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1961\",\n                    \"insertedRows\": 1692,\n                    \"size\": 2359296\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7757\",\n                    \"insertedRows\": 7754,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2092\",\n                    \"insertedRows\": 2020,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 5,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"947\",\n                    \"insertedRows\": 955,\n                    \"size\": 262144\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33070426,\n        \"File\": \"20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1720052874,\n            \"stopped_timestamp\": 1720052882,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-07-04 00:27:40\",\n    \"updated\": \"2024-07-04 00:28:02\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240704_022740_dble4a2h_assoenvolefr_94f8dddf2147c1df7374_20240704002740_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-07-04 00:28:02");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("129","20240718_020641_full18a2h_assoenvolefr","952eda3f37d235c08536_20240718000641","100","2024-07-18 00:06:41","unknown","{\n    \"ID\": 129,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240718_020641_full18a2h_assoenvolefr\",\n    \"Hash\": \"952eda3f37d235c08536_20240718000641\",\n    \"NameHash\": \"20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_scan.json\",\n    \"timer_start\": 1721261209.555548,\n    \"Runtime\": \"17.334 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.78MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105671959,\n        \"Dirs\": [],\n        \"DirCount\": 1246,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7712,\n        \"file_count\": 8958,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"6p76vkOsY5EhR\\/dgTLYHYX6v1pZVBwtS74Xr9cIzAA4PmiduFKX\\/PDp0asWxYakboME24BzMY4s392ZEFyoH4w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29431,\n            \"tablesSizeOnDisk\": 50724864,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 37,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"348\",\n                    \"insertedRows\": 422,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4747\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1399\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2165\",\n                    \"insertedRows\": 2174,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 47,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7446\",\n                    \"insertedRows\": 7755,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1644\",\n                    \"insertedRows\": 1870,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7618\",\n                    \"insertedRows\": 7756,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2086\",\n                    \"insertedRows\": 2146,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1322\",\n                    \"insertedRows\": 947,\n                    \"size\": 311296\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33197024,\n        \"File\": \"20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 81.42227717082694,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1721261227,\n            \"stopped_timestamp\": 1721261300,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-07-18 00:06:41\",\n    \"updated\": \"2024-07-18 00:08:20\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240718_020641_full18a2h_assoenvolefr_952eda3f37d235c08536_20240718000641_archive.zip","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-07-18 00:08:20"),
("130","20240804_020345_dble4a2h_assoenvolefr","385eb8a790f72bb22601_20240804000345","100","2024-08-04 00:03:45","unknown","{\n    \"ID\": 130,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240804_020345_dble4a2h_assoenvolefr\",\n    \"Hash\": \"385eb8a790f72bb22601_20240804000345\",\n    \"NameHash\": \"20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_scan.json\",\n    \"timer_start\": 1722729826.758757,\n    \"Runtime\": \"9.205 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.5MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5764399,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"k1JGLFJHsiyiCRwaPQc3Ycwi\\/F3UNycCJ1yoKozQcUyVEGqZWXAzPQGY7BmR\\/IfH2XMhFthX3eX07HXxea\\/h9w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27253,\n            \"tablesSizeOnDisk\": 50642944,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"37\",\n                    \"insertedRows\": 38,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"210\",\n                    \"insertedRows\": 450,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4329\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1139\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2277\",\n                    \"insertedRows\": 2228,\n                    \"size\": 196608\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 42,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"6077\",\n                    \"insertedRows\": 7756,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1890\",\n                    \"insertedRows\": 1898,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7757\",\n                    \"insertedRows\": 7757,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2016\",\n                    \"insertedRows\": 2164,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 1327,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33361010,\n        \"File\": \"20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1722729836,\n            \"stopped_timestamp\": 1722729843,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-08-04 00:03:45\",\n    \"updated\": \"2024-08-04 00:04:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240804_020345_dble4a2h_assoenvolefr_385eb8a790f72bb22601_20240804000345_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-08-04 00:04:03"),
("131","20240818_020331_full18a2h_assoenvolefr","4a3a79eb82493c249641_20240818000331","100","2024-08-18 00:03:31","unknown","{\n    \"ID\": 131,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240818_020331_full18a2h_assoenvolefr\",\n    \"Hash\": \"4a3a79eb82493c249641_20240818000331\",\n    \"NameHash\": \"20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_scan.json\",\n    \"timer_start\": 1723939418.723313,\n    \"Runtime\": \"539.283 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.78MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105673843,\n        \"Dirs\": [],\n        \"DirCount\": 1247,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7711,\n        \"file_count\": 8959,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"lKaAQt7VeEz9ssRU8t4YA8azppuymqjadmWddwqECikcTPFtaoZFonauy0vE0hScnC\\/Cif5B4KAhz5g\\/4xvvNA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28772,\n            \"tablesSizeOnDisk\": 51724288,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 39,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"320\",\n                    \"insertedRows\": 468,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4473\",\n                    \"insertedRows\": 4475,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1337\",\n                    \"insertedRows\": 1276,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"180\",\n                    \"insertedRows\": 180,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2027\",\n                    \"insertedRows\": 2013,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 62,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7738\",\n                    \"insertedRows\": 7758,\n                    \"size\": 4718592\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1884\",\n                    \"insertedRows\": 1931,\n                    \"size\": 2408448\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7350\",\n                    \"insertedRows\": 7758,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2044\",\n                    \"insertedRows\": 2250,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"947\",\n                    \"insertedRows\": 955,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33398736,\n        \"File\": \"20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 91.09893536653244,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1723939958,\n            \"stopped_timestamp\": 1723940023,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-08-18 00:03:31\",\n    \"updated\": \"2024-08-18 00:13:43\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240818_020331_full18a2h_assoenvolefr_4a3a79eb82493c249641_20240818000331_archive.zip","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-08-18 00:13:43"),
("132","20240904_020741_dble4a2h_assoenvolefr","77aa21d364e819b96460_20240904000741","100","2024-09-04 00:07:41","unknown","{\n    \"ID\": 132,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240904_020741_dble4a2h_assoenvolefr\",\n    \"Hash\": \"77aa21d364e819b96460_20240904000741\",\n    \"NameHash\": \"20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_scan.json\",\n    \"timer_start\": 1725408463.321024,\n    \"Runtime\": \"9.327 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.48MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5749972,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"IrnmwzxuhavC3Ghoe4Y\\/45aOyBAKnBRxNa0+vZHsXB\\/X1DeMjBaRw8FeT16zvS8gf5ntcUKKlkdIuwdlswfisw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29713,\n            \"tablesSizeOnDisk\": 51822592,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 40,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"344\",\n                    \"insertedRows\": 292,\n                    \"size\": 1179648\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4540\",\n                    \"insertedRows\": 4484,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1238\",\n                    \"insertedRows\": 1278,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1952\",\n                    \"insertedRows\": 1973,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 42,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7779\",\n                    \"insertedRows\": 7759,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"2085\",\n                    \"insertedRows\": 1778,\n                    \"size\": 2408448\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7773\",\n                    \"insertedRows\": 7759,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2032\",\n                    \"insertedRows\": 2049,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1334\",\n                    \"insertedRows\": 947,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33293580,\n        \"File\": \"20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1725408472,\n            \"stopped_timestamp\": 1725408483,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-09-04 00:07:41\",\n    \"updated\": \"2024-09-04 00:08:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240904_020741_dble4a2h_assoenvolefr_77aa21d364e819b96460_20240904000741_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-09-04 00:08:03"),
("133","20240918_021907_full18a2h_assoenvolefr","66f53d230665f3fa2004_20240918001907","-1","2024-09-18 00:19:07","unknown","{\n    \"ID\": 133,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240918_021907_full18a2h_assoenvolefr\",\n    \"Hash\": \"66f53d230665f3fa2004_20240918001907\",\n    \"NameHash\": \"20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_scan.json\",\n    \"timer_start\": 1726618756.325374,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 193166298,\n        \"Dirs\": [],\n        \"DirCount\": 1248,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7712,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"YhyQmKACiS4KeDfeTWXfAVzfQFk2FsA8k8jxdi+n3quhpUKNjx1JyGO1WL+jsy77kZGzbVtZKYJzFi4M9vhEZg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28068,\n            \"tablesSizeOnDisk\": 50610176,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 41,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"301\",\n                    \"insertedRows\": 248,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4411\",\n                    \"insertedRows\": 4484,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1128\",\n                    \"insertedRows\": 1277,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 181,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"2110\",\n                    \"insertedRows\": 2096,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7302\",\n                    \"insertedRows\": 7759,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1851\",\n                    \"insertedRows\": 1601,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7313\",\n                    \"insertedRows\": 7759,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2064\",\n                    \"insertedRows\": 2063,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 1251,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33133583,\n        \"File\": \"20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-09-18 00:19:07\",\n    \"updated\": \"2024-09-18 00:19:26\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240918_021907_full18a2h_assoenvolefr_66f53d230665f3fa2004_20240918001907_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.16.4","2024-09-18 00:19:26"),
("134","20240924_104656_full18a2h_assoenvolefr","da3498fc859ef0155190_20240924084656","100","2024-09-24 08:46:56","unknown","{\n    \"ID\": 134,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240924_104656_full18a2h_assoenvolefr\",\n    \"Hash\": \"da3498fc859ef0155190_20240924084656\",\n    \"NameHash\": \"20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_scan.json\",\n    \"timer_start\": 1727167620.454734,\n    \"Runtime\": \"13.135 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.87MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105764681,\n        \"Dirs\": [],\n        \"DirCount\": 1248,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7711,\n        \"file_count\": 8960,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"CKanACyrtY7Xyoo5YTs+RXle8JTqabEG69sdzD\\/7a\\/JSSbaly1IAbFS\\/3OUWGX9ThAjSMMUiTLKMs7a354VQhw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 28537,\n            \"tablesSizeOnDisk\": 50692096,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"41\",\n                    \"insertedRows\": 42,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"215\",\n                    \"insertedRows\": 259,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4311\",\n                    \"insertedRows\": 4484,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1188\",\n                    \"insertedRows\": 1278,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 182,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1987\",\n                    \"insertedRows\": 1999,\n                    \"size\": 180224\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 28,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7673\",\n                    \"insertedRows\": 7761,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1564\",\n                    \"insertedRows\": 1847,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7709\",\n                    \"insertedRows\": 7761,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2011\",\n                    \"insertedRows\": 2021,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 2,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1252\",\n                    \"insertedRows\": 1252,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33656910,\n        \"File\": \"20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 94.88871327950135,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1727167633,\n            \"stopped_timestamp\": 1727167696,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-09-24 08:46:56\",\n    \"updated\": \"2024-09-24 08:48:16\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20240924_104656_full18a2h_assoenvolefr_da3498fc859ef0155190_20240924084656_archive.zip","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-09-24 08:48:16"),
("135","20241004_022336_dble4a2h_assoenvolefr","a85641947eeb64876508_20241004002336","100","2024-10-04 00:23:36","unknown","{\n    \"ID\": 135,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241004_022336_dble4a2h_assoenvolefr\",\n    \"Hash\": \"a85641947eeb64876508_20241004002336\",\n    \"NameHash\": \"20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_scan.json\",\n    \"timer_start\": 1728001417.747537,\n    \"Runtime\": \"8.367 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.49MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5756548,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"k+XQo31PJeuHgLP9RXSYsHVLgnQOBIMORuAgeNEMa0CPVvmPcyRfxuHgeXFPPLSneMIiqWxhJRMKujNzE5Ks9Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 29004,\n            \"tablesSizeOnDisk\": 51691520,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 43,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"257\",\n                    \"insertedRows\": 220,\n                    \"size\": 2195456\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4489\",\n                    \"insertedRows\": 4486,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1234\",\n                    \"insertedRows\": 1281,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"200\",\n                    \"insertedRows\": 200,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1776\",\n                    \"insertedRows\": 1720,\n                    \"size\": 147456\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"8085\",\n                    \"insertedRows\": 7771,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1619\",\n                    \"insertedRows\": 1703,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7591\",\n                    \"insertedRows\": 7771,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2034\",\n                    \"insertedRows\": 2005,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"1256\",\n                    \"insertedRows\": 947,\n                    \"size\": 294912\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33258108,\n        \"File\": \"20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1728001426,\n            \"stopped_timestamp\": 1728001434,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-10-04 00:23:36\",\n    \"updated\": \"2024-10-04 00:23:55\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241004_022336_dble4a2h_assoenvolefr_a85641947eeb64876508_20241004002336_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-10-04 00:23:55");

INSERT IGNORE INTO `pp5_duplicator_backups` VALUES 
("136","20241018_022016_full18a2h_assoenvolefr","d8a32a0682efd7361315_20241018002016","-1","2024-10-18 00:20:16","unknown","{\n    \"ID\": 136,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241018_022016_full18a2h_assoenvolefr\",\n    \"Hash\": \"d8a32a0682efd7361315_20241018002016\",\n    \"NameHash\": \"20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_scan.json\",\n    \"timer_start\": 1729210823.664096,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 193924769,\n        \"Dirs\": [],\n        \"DirCount\": 1249,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7722,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"TyFVspSVlNQFZK8IDt+kN4RUywPAuJ3h+9lRWJRi5Uc24xNspgZ3WKqdAnXCQEQOFpNZ4AoRnDn33K5DOvF5tw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27779,\n            \"tablesSizeOnDisk\": 50610176,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 44,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"300\",\n                    \"insertedRows\": 239,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4358\",\n                    \"insertedRows\": 4504,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1117\",\n                    \"insertedRows\": 1281,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"200\",\n                    \"insertedRows\": 200,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1417\",\n                    \"insertedRows\": 1404,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 18,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 11,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7570\",\n                    \"insertedRows\": 7773,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1826\",\n                    \"insertedRows\": 1934,\n                    \"size\": 1310720\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7527\",\n                    \"insertedRows\": 7773,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2035\",\n                    \"insertedRows\": 2016,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 1255,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33310610,\n        \"File\": \"20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-10-18 00:20:16\",\n    \"updated\": \"2024-10-18 00:20:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241018_022016_full18a2h_assoenvolefr_d8a32a0682efd7361315_20241018002016_archive.zip","-1","SCHEDULE,ZIP_ARCHIVE","4.5.16.4","2024-10-18 00:20:32"),
("137","20241028_161826_full18a2h_assoenvolefr","98923af9b23d23fa4605_20241028151826","100","2024-10-28 15:18:26","unknown","{\n    \"ID\": 137,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241028_161826_full18a2h_assoenvolefr\",\n    \"Hash\": \"98923af9b23d23fa4605_20241028151826\",\n    \"NameHash\": \"20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_scan.json\",\n    \"timer_start\": 1730128710.805808,\n    \"Runtime\": \"28.049 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"101.01MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105920839,\n        \"Dirs\": [],\n        \"DirCount\": 1249,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7721,\n        \"file_count\": 8971,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"Y34wNeAvDNN+xWqHMsjKkMqp\\/k67eJY2XjI6y6lgKvMqKE4IbpNViwTmgbufG3jYh7bUnKMn27kAYa61AUcH9Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27933,\n            \"tablesSizeOnDisk\": 50544640,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"44\",\n                    \"insertedRows\": 45,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"256\",\n                    \"insertedRows\": 310,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4551\",\n                    \"insertedRows\": 4504,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1278\",\n                    \"insertedRows\": 1282,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"200\",\n                    \"insertedRows\": 201,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1486\",\n                    \"insertedRows\": 1460,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 17,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"7354\",\n                    \"insertedRows\": 7773,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1658\",\n                    \"insertedRows\": 1868,\n                    \"size\": 1277952\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7741\",\n                    \"insertedRows\": 7773,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2006\",\n                    \"insertedRows\": 2072,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"947\",\n                    \"insertedRows\": 955,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33773785,\n        \"File\": \"20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 88.95565322179141,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1730128739,\n            \"stopped_timestamp\": 1730128806,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-10-28 15:18:26\",\n    \"updated\": \"2024-10-28 15:20:06\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241028_161826_full18a2h_assoenvolefr_98923af9b23d23fa4605_20241028151826_archive.zip","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-10-28 15:20:06"),
("138","20241104_020042_dble4a2h_assoenvolefr","11b88adbbed1ca163812_20241104010042","100","2024-11-04 01:00:42","unknown","{\n    \"ID\": 138,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241104_020042_dble4a2h_assoenvolefr\",\n    \"Hash\": \"11b88adbbed1ca163812_20241104010042\",\n    \"NameHash\": \"20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_scan.json\",\n    \"timer_start\": 1730682043.195891,\n    \"Runtime\": \"8.244 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.5MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5764284,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"3iB05T7tFbolaIWEntyslhY+C0b6eF2EJ8F4\\/O9jW83FdtcvCG87X3\\/SFwvXOU5NJdDq4ekBTvo0Gaz9vrGkFg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27190,\n            \"tablesSizeOnDisk\": 50561024,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"45\",\n                    \"insertedRows\": 46,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"302\",\n                    \"insertedRows\": 302,\n                    \"size\": 1146880\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4491\",\n                    \"insertedRows\": 4504,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1223\",\n                    \"insertedRows\": 1282,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"200\",\n                    \"insertedRows\": 200,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1559\",\n                    \"insertedRows\": 1561,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 41,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"6633\",\n                    \"insertedRows\": 7774,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1674\",\n                    \"insertedRows\": 1659,\n                    \"size\": 1294336\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7645\",\n                    \"insertedRows\": 7774,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2034\",\n                    \"insertedRows\": 2066,\n                    \"size\": 1228800\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 955,\n                    \"size\": 229376\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33331148,\n        \"File\": \"20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1730682051,\n            \"stopped_timestamp\": 1730682060,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-11-04 01:00:42\",\n    \"updated\": \"2024-11-04 01:01:00\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241104_020042_dble4a2h_assoenvolefr_11b88adbbed1ca163812_20241104010042_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-11-04 01:01:00"),
("139","20241118_022237_full18a2h_assoenvolefr","db651958a06adba21037_20241118012237","100","2024-11-18 01:22:37","unknown","{\n    \"ID\": 139,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.35\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241118_022237_full18a2h_assoenvolefr\",\n    \"Hash\": \"db651958a06adba21037_20241118012237\",\n    \"NameHash\": \"20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_scan.json\",\n    \"timer_start\": 1731892962.63095,\n    \"Runtime\": \"19.037 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.95MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 105857442,\n        \"Dirs\": [],\n        \"DirCount\": 1250,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 7721,\n        \"file_count\": 8972,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_installer.php\",\n        \"Size\": 131961,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"r8UXlHaBLSiEnXbHDchmspnILBGuu1mFp\\/63p1Hvfa5IG9v4HtaOhYr5EnaTMamlIN8mmskbdm+1xCanDMLYAQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27433,\n            \"tablesSizeOnDisk\": 50577408,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"46\",\n                    \"insertedRows\": 47,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 205,\n                    \"size\": 1130496\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4612\",\n                    \"insertedRows\": 4504,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1221\",\n                    \"insertedRows\": 1281,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"200\",\n                    \"insertedRows\": 200,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1301\",\n                    \"insertedRows\": 1301,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"6962\",\n                    \"insertedRows\": 7775,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"1943\",\n                    \"insertedRows\": 1900,\n                    \"size\": 1327104\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7597\",\n                    \"insertedRows\": 7775,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2006\",\n                    \"insertedRows\": 2000,\n                    \"size\": 1212416\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"947\",\n                    \"insertedRows\": 947,\n                    \"size\": 245760\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.35\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33407985,\n        \"File\": \"20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 9,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 69.68617513582937,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1731892981,\n            \"stopped_timestamp\": 1731893038,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-11-18 01:22:37\",\n    \"updated\": \"2024-11-18 01:23:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241118_022237_full18a2h_assoenvolefr_db651958a06adba21037_20241118012237_archive.zip","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-11-18 01:23:59"),
("140","20241204_020123_dble4a2h_assoenvolefr","ec23f2b4e3cb34798621_20241204010123","100","2024-12-04 01:01:23","unknown","{\n    \"ID\": 140,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241204_020123_dble4a2h_assoenvolefr\",\n    \"Hash\": \"ec23f2b4e3cb34798621_20241204010123\",\n    \"NameHash\": \"20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule dble4a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_scan.json\",\n    \"timer_start\": 1733274084.579642,\n    \"Runtime\": \"7.710 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"5.52MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-admin\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/languages\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/mu-plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/themes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/upgrade-temp-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wflogs\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-includes\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.ovhconfig\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.user.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/license.txt\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/php.ini\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/readme.html\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/web.config\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-activate.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-blog-header.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-comments-post.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config-sample.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-config.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/debug.log\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/index.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-cron.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-links-opml.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-load.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-login.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-mail.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-settings.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-signup.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-trackback.php\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/xmlrpc.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\",\n        \"Size\": 5782966,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": 2,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"iqXcDMf3xetTiWbZ6axCgV9xK9TlA1y3nvxXiKwd3GGes8LGJlFTfQdRZVs527J\\/f2kESSM43jnKuGN0sXq7Sw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cpsbd\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 27558,\n            \"tablesSizeOnDisk\": 50659328,\n            \"tablesList\": {\n                \"pp5_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"pp5_duplicator_backups\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 48,\n                    \"size\": 1703936\n                },\n                \"pp5_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 196608\n                },\n                \"pp5_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_options\": {\n                    \"inaccurateRows\": \"362\",\n                    \"insertedRows\": 362,\n                    \"size\": 1163264\n                },\n                \"pp5_postmeta\": {\n                    \"inaccurateRows\": \"4735\",\n                    \"insertedRows\": 4516,\n                    \"size\": 1916928\n                },\n                \"pp5_posts\": {\n                    \"inaccurateRows\": \"1161\",\n                    \"insertedRows\": 1284,\n                    \"size\": 32931840\n                },\n                \"pp5_term_relationships\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"pp5_term_taxonomy\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"pp5_terms\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 49152\n                },\n                \"pp5_usermeta\": {\n                    \"inaccurateRows\": \"202\",\n                    \"insertedRows\": 202,\n                    \"size\": 81920\n                },\n                \"pp5_users\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 65536\n                },\n                \"pp5_wfblockediplog\": {\n                    \"inaccurateRows\": \"1276\",\n                    \"insertedRows\": 1276,\n                    \"size\": 131072\n                },\n                \"pp5_wfblocks7\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 29,\n                    \"size\": 65536\n                },\n                \"pp5_wfconfig\": {\n                    \"inaccurateRows\": \"276\",\n                    \"insertedRows\": 279,\n                    \"size\": 1359872\n                },\n                \"pp5_wfcrawlers\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 16384\n                },\n                \"pp5_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wffilemods\": {\n                    \"inaccurateRows\": \"6643\",\n                    \"insertedRows\": 7777,\n                    \"size\": 4734976\n                },\n                \"pp5_wfhits\": {\n                    \"inaccurateRows\": \"2200\",\n                    \"insertedRows\": 2113,\n                    \"size\": 1327104\n                },\n                \"pp5_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfknownfilelist\": {\n                    \"inaccurateRows\": \"7495\",\n                    \"insertedRows\": 7777,\n                    \"size\": 2637824\n                },\n                \"pp5_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wflogins\": {\n                    \"inaccurateRows\": \"2062\",\n                    \"insertedRows\": 2101,\n                    \"size\": 1245184\n                },\n                \"pp5_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"pp5_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"pp5_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"pp5_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"pp5_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"pp5_wfreversecache\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 16384\n                },\n                \"pp5_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfsnipcache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"pp5_wfstatus\": {\n                    \"inaccurateRows\": \"955\",\n                    \"insertedRows\": 955,\n                    \"size\": 262144\n                },\n                \"pp5_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"pp5_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 33430186,\n        \"File\": \"20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\\/20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 8,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1733274092,\n            \"stopped_timestamp\": 1733274101,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 6,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-12-04 01:01:23\",\n    \"updated\": \"2024-12-04 01:01:41\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"DB_ONLY\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241204_020123_dble4a2h_assoenvolefr_ec23f2b4e3cb34798621_20241204010123_archive.zip","100","SCHEDULE,DB_ONLY,HAVE_REMOTE,ZIP_ARCHIVE","4.5.16.4","2024-12-04 01:01:41"),
("141","20241218_021335_full18a2h_assoenvolefr","79ec7a56449ec6417195_20241218011335","100","2024-12-18 01:13:35","unknown","{\n    \"ID\": 141,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.0.37\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20241218_021335_full18a2h_assoenvolefr\",\n    \"Hash\": \"79ec7a56449ec6417195_20241218011335\",\n    \"NameHash\": \"20241218_021335_full18a2h_assoenvolefr_79ec7a56449ec6417195_20241218011335\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule full18a2h\",\n    \"StorePath\": \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.asso-envole.fr\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241218_021335_full18a2h_assoenvolefr_79ec7a56449ec6417195_20241218011335_scan.json\",\n    \"timer_start\": 1734484423.901261,\n    \"Runtime\": \"13.812 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"101.22MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.opcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.tmb\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/bps-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/old-cache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/updraft\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wfcache\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/formatioea\\/envole\\/envole69\\/ftp\\/www\\/.htaccess\",\n            \"