## Here are ways to get involved:

1. [Star](https://github.com/timber/timber/stargazers) the project!
2. Answer questions that come through [GitHub issues](https://github.com/timber/timber/issues?state=open)
3. [Report a bug](https://github.com/timber/timber/issues/new) that you find
4. Share a [theme](https://github.com/Upstatement/blades) you've built with Timber. This helps transfer knowledge about best practices, etc. _Add it to the [Showcase list](https://github.com/timber/timber/wiki/Showcase)_
5. Tweet and [blog](http://www.oomphinc.com/blog/2013-10/php-templating-wordpress/#post-content) about the advantages (and criticisms) of the project and Twig
6. Browse [contrib opportunities](https://github.com/timber/timber/issues?labels=contrib-opportunity&page=1&state=open) for areas of WordPress/PHP/code you know well to consider, build or document.


### Pull Requests

Pull requests are highly appreciated. More than fifty people have written parts of Timber (so far). Here are some guidelines to help:

1. **Solve a problem** Features are great, but even better is cleaning-up and fixing issues in the code that you discover.
2. **Write tests** This helps preserve functionality as the codebase grows and demonstrates how your change affects the code.
3. **Small > big** Better to have a few small PRs that address specific parts of the code, than one big PR that jumps all over.
4. **Comply with standards** We follow [WordPress coding standards](https://make.wordpress.org/core/handbook/coding-standards/php/) -- which sometimes deviate from [PSR-2](http://www.php-fig.org/psr/psr-2/) and others.
