<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>
<div id="site" class="site">
	<header id="header" class="site-header"
        <?php
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
            $home_top_background_image_url = get_theme_mod( 'home_header' );
            if($featured_img_url): ?>
            style="background: url('<?php echo $featured_img_url; ?>'); background-size: cover;"
            <?php
            else: ?>
            style="background: url(<?php echo $home_top_background_image_url; ?>) no-repeat; background-size: cover;"
            <?php
            endif; ?>
            >

		<!-- header.twig start -->
        <?php
        $context = Timber::get_context();
        $context['post'] = new Timber\Post(); // It's a new Timber\Post object, but an existing post from WordPress.

        if(is_page_template('page-templates/onepage.php')):
            Timber::render( 'header-home.twig', $context );
        elseif(is_page()):
            Timber::render( 'header-page.twig', $context );
        else:
            Timber::render( 'header-single.twig', $context );
        endif;
        ?>
		<!-- header.twig end -->
	</header>

	<aside id="aside" class="site-aside">
		<!-- aside.twig start -->
		<?php Timber::render( 'aside.twig', $context ); ?>
		<!-- aside.twig end -->
	</aside>

	<div id="content" class="site-content">
		<!-- .site-content start -->

        <div class="wrap">
            <!-- .wrap start -->
