<?php
/*
 Theme Shortcode
*/




/*************  clearfix *****************/
add_shortcode( 'clearfix', 'shortcode_clearfix' );
function shortcode_clearfix() {
   return "<div class='cf'></div>";
}




/*************  shortcode_empty_paragraph_fix *****************/
add_filter( 'the_content', 'shortcode_empty_paragraph_fix' );
function shortcode_empty_paragraph_fix( $content ) {

	$array = array (
		'<p>[' => '[',
		']</p>' => ']',
		']<br />' => ']'
	);

	$content = strtr( $content, $array );

	return $content;
}




/*************  span *****************/
add_shortcode( 'span', 'shortcode_span' );
function shortcode_span($atts, $content=null) {

	extract( shortcode_atts( array( 'id' => '',	'class' => '' ,	'style' => '' ), $atts, 'span'));

	$o = '<span';
	foreach ($atts as $key => $value) $o .= ' '.$key.'="'.$value.'"';
   	$o .= '>';
	if ($content) return $o.do_shortcode($content).'</span>';
	else return $o;
}
/* explicite close */
add_shortcode( 'endspan', 'shortcode_endspan' );
function shortcode_endspan() {
	return '</span>';
}




/*************  div *****************/
add_shortcode( 'div', 'shortcode_div' );
function shortcode_div($atts, $content=null) {

	extract( shortcode_atts( array( 'id' => '',	'class' => '' ,	'style' => '' ), $atts, 'div'));

	$o = '<div';
	foreach ($atts as $key => $value) $o .= ' '.$key.'="'.$value.'"';
   	$o .= '>';
	if ($content) return $o.do_shortcode($content).'</div>';
	else return $o;
}
/* explicite close */
add_shortcode( 'enddiv', 'shortcode_enddiv' );
function shortcode_enddiv() {
	return '</div>';
}




/*************  module *****************/
add_shortcode( 'module', 'shortcode_module' );
function shortcode_module($atts, $content=null) {

	extract( shortcode_atts( array( 'name' => '' ), $atts, 'module'));

	require_once( __DIR__.'/../lib/'.$name.'/'.$name.'.php' );

	$l_sName2call='shortcode_'.$name;
	unset($atts['name']);
	return $l_sName2call($atts,$content);
}



/*************  twig *****************/
add_shortcode( 'twig', 'shortcode_twig' );
function shortcode_twig($atts, $content=null) {
	extract( shortcode_atts( array( 'name' => '' ), $atts, 'module'));
	unset($atts['name']);
	if ($content) $atts['content']=$content;
	return 	Timber::compile( $name.'.twig', $atts );
}


/*************  menu *****************/
function shortcode_menu($atts, $content = null) {
    extract(shortcode_atts(array( 'name' => null, ), $atts, 'menu'));
    return wp_nav_menu( array( 'menu' => $name, 'echo' => false ) );
}
add_shortcode('menu', 'shortcode_menu');





/*************  font awesome *****************/
add_shortcode( 'fa', 'shortcode_fa' );
function shortcode_fa($atts, $content=null) {

	extract( shortcode_atts( array( 'class' => 'flag' ), $atts, 'fa'));

	$o = '';
	$o .= '<i class="'.$class.'" ></i>';
	// if (is_array($atts)) foreach ($atts as $key => $value) $o .= ' '.$key.'="'.$value.'"';
   	// $o .= '><div class="wrap"><div class="row">';
	// if ($content) return $o.do_shortcode($content).'</section>';
	// else return $o;
	return $o;
}

add_shortcode( 'FacebookTimeline', 'FacebookTimeline_integration' );
function FacebookTimeline_integration($atts, $content=null){
    extract( shortcode_atts( array('titre' => '','url' => ''), $atts, 'FacebookTimeline_integration'));

    $codehtml = '
<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/fr_FR/sdk.js#xfbml=1&version=v2.10";
  fjs.parentNode.insertBefore(js, fjs);
}(document, "script", "facebook-jssdk"));</script>
<div class="fb-page" data-href="'.$url.'" data-tabs="timeline" data-width="500" data-height="600" data-small-header="true" data-adapt-container-width="true" data-hide-cover="true" data-show-facepile="false" data-adapt-container-width="true"><blockquote cite="'.$url.'" class="fb-xfbml-parse-ignore"><a href="'.$url.'">'.$titre.'</a></blockquote></div>
';
	return $codehtml;
}

/************* @cn 13/10/2025 Date footer ************/
add_shortcode('annee', 'shortcode_annee');
function shortcode_annee(){
    $o = '';
    $o .= date('Y');
    return $o;
}
