<?php
/*
Description: module agenda
*/

add_action( 'init', function(){
	
	// creation du nouveau post type
	register_post_type( 'agenda',
		array(
			'labels' => array(
				'name' => 'Agenda',
				'singular_name' => 'Evènement',
				'new_item' => 'Nouveau ',
				'view_item' => 'Afficher',
				'add_new_item' => 'Ajouter',
				'edit_item' => 'Modifier',
				'not_found' => 'Aucun élément',
				'not_found_in_trash' => 'La corbeille est vide',
			),
			'public' => true,
			'has_archive' => false,
			'publicly_queryable'  => false,
			'supports'      => array( 'title' ),
		)
	);
			
}); //init


/************* SHORTCODE POUR LA PAGE AGENDA *****************************/

function agenda_list_sc($atts, $contenu=null) {

$o = '';
$args = array(
	'post_type'      => 'agenda',
	'posts_per_page' => -1,
	'meta_query' => array(
		array(
			'key' => 'date',
			'value' => date('Ymd'),
			'compare' => '>=',
			'type' => 'DATE'
		)
	),
	'orderby' => array(
		'date' => 'ASC',
	),
);
	
// chargement des données
$la_posts=get_posts($args);	

foreach($la_posts as $lo_post){
		
	$post_id=$lo_post->ID;
	
	// création du contexte pour twig
	$context=get_fields($post_id);
	$context['post_title']=get_the_title($post_id);
	//$context['post_name']=$lo_post->post_name; 
	$context['post_content']=get_the_content($post_id);
	$context['post_permalink']=get_the_permalink($post_id);
    $l_sContent = $lo_post->description;
    $l_sContent = str_replace( ']]>', ']]&gt;', $l_sContent );
    $context['post_content']=wp_trim_words($l_sContent);
	
	// affichage du contexte dans la console pour aider la création de la vue
	$o.= '<script>console.log('.json_encode($context).');</script>';

	// exécution de la vue twig avec les données dans $context
	$o.=Timber::compile( 'agenda-list-item.twig', $context );

}
  
	return $o;	
}

add_shortcode( 'agenda-list', 'agenda_list_sc' );

function agenda_archive_sc($atts, $contenu=null) {

$o = '';
$args = array(
	'post_type'      => 'agenda',
	'posts_per_page' => -1,
	'meta_query' => array(
		array(
			'key' => 'date',
			'value' => date('Ymd'),
			'compare' => '<',
			'type' => 'DATE'
		)
	),
	'orderby' => array(
		'date' => 'DESC', // 31 01 2020 : changement
	),
);
	
// chargement des données
$la_posts=get_posts($args);	

foreach($la_posts as $lo_post){
		
	$post_id=$lo_post->ID;
	
	// création du contexte pour twig
	$context=get_fields($post_id);
	$context['post_title']=get_the_title($post_id);
	//$context['post_name']=$lo_post->post_name; 
	$context['post_content']=get_the_content($post_id);
	$context['post_permalink']=get_the_permalink($post_id);
    $l_sContent = $lo_post->description;
    $l_sContent = str_replace( ']]>', ']]&gt;', $l_sContent );
    $context['post_content']=wp_trim_words($l_sContent);
	
	// affichage du contexte dans la console pour aider la création de la vue
	$o.= '<script>console.log('.json_encode($context).');</script>';

	// exécution de la vue twig avec les données dans $context
	$o.=Timber::compile( 'agenda-list-item.twig', $context );

}
  
	return $o;	
}

add_shortcode( 'agenda-archive', 'agenda_archive_sc' );


/******************** SHORTCODE POUR LA PAGE D'ACCUEIL *********************************/

function upcoming_list_sc($atts, $contenu=null) {

	$o = '';
	$args = array(
		'post_type'      => 'agenda',
		'posts_per_page' => 3,
		'meta_query' => array(
			array(
				'key' => 'date',
				'value' => date('Ymd'),
				'compare' => '>=',
				'type' => 'DATE'
			)
		),
		'orderby' => array(
			'date' => 'ASC', 
		),
	);
		
	// chargement des données
	$la_posts=get_posts($args);	

	foreach($la_posts as $lo_post){
			
		$post_id=$lo_post->ID;
		
		// création du contexte pour twig
		$context=get_fields($post_id);
		$context['post_title']=get_the_title($post_id);
		//$context['post_name']=$lo_post->post_name;
		$context['post_content']=get_the_content($post_id);
		$context['post_permalink']=get_the_permalink($post_id);
		

		// exécution de la vue twig avec les données dans $context
		$o.=Timber::compile( 'upcoming-list.twig', $context );

	}

	// 31 01 2020 : si pas evts futur, on affiche les 3 derniers
	if (count($la_posts)==0){
		$args = array(
			'post_type'      => 'agenda',
			'posts_per_page' => 3,
			/* 'meta_query' => array(
				array(
					'key' => 'date',
					'value' => date('Ymd'),
					'compare' => '>=',
					'type' => 'DATE'
				)
			), */
			'orderby' => array(
				'date' => 'DESC', 
			),
		);
			
		// chargement des données
		$la_posts=get_posts($args);	

		foreach($la_posts as $lo_post){
				
			$post_id=$lo_post->ID;
			
			// création du contexte pour twig
			$context=get_fields($post_id);
			$context['post_title']=get_the_title($post_id);
			//$context['post_name']=$lo_post->post_name;
			$context['post_content']=get_the_content($post_id);
			$context['post_permalink']=get_the_permalink($post_id);
			

			// exécution de la vue twig avec les données dans $context
			$o.=Timber::compile( 'upcoming-list.twig', $context );

		}
	}

  
	return $o;	
}

add_shortcode( 'upcoming-list', 'upcoming_list_sc' );
	