<?php

/**
* This function will apply changes to the uploaded file
* @param $image_data - contains file, url, type
*/

function resize_handle_upload($image_data){
	
	//return if not an image
	$fileinfo=pathinfo($image_data['file']);
	switch(strtolower($fileinfo['extension'])){
		case 'jpg':
		case 'jpeg':
		case 'png':
			break;
		default:
			return $image_data;
	}
		
	$max_width=get_theme_mod('custom_theme_imgautoresize_width', '960' );
	$max_height=get_theme_mod('custom_theme_imgautoresize_height', '640' );
	$compression_level=get_theme_mod('custom_theme_compression_level', '70' );
	// if (!is_int($max_width)) $max_width=960;
	// if (!is_int($max_height)) $max_height=640;
	// if (!is_int($compression_level)) $compression_level=70;
	
	//avoid file starting or ending with
	$key = 'full';
	$fileinfo=pathinfo($image_data['file']);
	$pos = stripos($fileinfo['filename'], $key);
	$endpos = strlen($fileinfo['filename']) - strlen($key);
	if ($pos !== false) {
		if ($pos==0) return $image_data;
		if ($pos==$endpos) return $image_data;		
	}
	
    $image_editor = wp_get_image_editor($image_data['file']);
	if ( is_wp_error( $image ) ) return $image_data;

	$sizes = $image_editor->get_size();
	
	if((isset($sizes['width']) && $sizes['width'] > $max_width) || (isset($sizes['height']) && $sizes['height'] > $max_height)) {

		$image_editor->resize($max_width, $max_height, false);
		$image_editor->set_quality($compression_level);
		$saved_image = $image_editor->save($image_data['file']);
	}
		
	return $image_data;

} // function resize_handle_upload($image_data){
add_action('wp_handle_upload', 'resize_handle_upload');



function remove_default_image_sizes( $sizes) {
    unset( $sizes['medium_large']);
    return $sizes;
}
add_filter('intermediate_image_sizes_advanced','remove_default_image_sizes');



//elimine les accents des noms des fichiers
function clean_upload_filename($filename) {

		$invalid = array(
			'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ā'=>'A', 'Ă'=>'A', 'Ȧ'=>'A', 'Ä'=>'A', 'Ả'=>'A', 'Å'=>'A', 'Ǎ'=>'A', 'Ȁ'=>'A', 'Ȃ'=>'A', 'Ą'=>'A', 'Ạ'=>'A', 'Ḁ'=>'A', 'Ầ'=>'A', 'Ấ'=>'A', 'Ẫ'=>'A', 'Ẩ'=>'A', 'Ằ'=>'A', 'Ắ'=>'A', 'Ẵ'=>'A', 'Ẳ'=>'A', 'Ǡ'=>'A', 'Ǟ'=>'A', 'Ǻ'=>'A', 'Ậ'=>'A', 'Ặ'=>'A',
			'Æ'=>'AE', 'Ǽ'=>'AE', 'Ǣ'=>'AE', 
			'Ḃ'=>'B', 'Ɓ'=>'B', 'Ḅ'=>'B', 'Ḇ'=>'B', 'Ƃ'=>'B', 'Ƅ'=>'B', 'Þ'=>'B',
			'Ĉ'=>'C', 'Ċ'=>'C', 'Č'=>'C', 'Ƈ'=>'C', 'Ç'=>'C', 'Ḉ'=>'C',
			'Ḋ'=>'D', 'Ɗ'=>'D', 'Ḍ'=>'D', 'Ḏ'=>'D', 'Ḑ'=>'D', 'Ḓ'=>'D', 'Ď'=>'D',
			'Đ'=>'Dj', 'Ɖ'=>'Dj',
			'È'=>'E', 'É'=>'E', 'Ê'=>'E', 'Ẽ'=>'E', 'Ē'=>'E', 'Ĕ'=>'E', 'Ė'=>'E', 'Ë'=>'E', 'Ẻ'=>'E', 'Ě'=>'E', 'Ȅ'=>'E', 'Ȇ'=>'E', 'Ẹ'=>'E', 'Ȩ'=>'E', 'Ę'=>'E', 'Ḙ'=>'E', 'Ḛ'=>'E', 'Ề'=>'E', 'Ế'=>'E', 'Ễ'=>'E', 'Ể'=>'E', 'Ḕ'=>'E', 'Ḗ'=>'E', 'Ệ'=>'E', 'Ḝ'=>'E', 'Ǝ'=>'E', 'Ɛ'=>'E', 
			'Ḟ'=>'F', 'Ƒ'=>'F', 
			'Ǵ'=>'G', 'Ĝ'=>'G', 'Ḡ'=>'G', 'Ğ'=>'G', 'Ġ'=>'G', 'Ǧ'=>'G', 'Ɠ'=>'G', 'Ģ'=>'G', 'Ǥ'=>'G', 
			'Ĥ'=>'H', 'Ḧ'=>'H', 'Ȟ'=>'H', 'Ƕ'=>'H', 'Ḥ'=>'H', 'Ḩ'=>'H', 'Ḫ'=>'H', 'Ħ'=>'H',
			'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ĩ'=>'I', 'Ī'=>'I', 'Ĭ'=>'I', 'İ'=>'I', 'Ï'=>'I', 'Ỉ'=>'I', 'Ǐ'=>'I', 'Ị'=>'I', 'Į'=>'I', 'Ȉ'=>'I', 'Ȋ'=>'I', 'Ḭ'=>'I', 'Ɨ'=>'I', 'Ḯ'=>'I', 
			'Ĳ'=>'IJ',
			'Ĵ'=>'J',
			'Ḱ'=>'K', 'Ǩ'=>'K', 'Ḵ'=>'K', 'Ƙ'=>'K', 'Ḳ'=>'K', 'Ķ'=>'K', 'Ĺ'=>'L', 'Ḻ'=>'L', 'Ḷ'=>'L', 'Ļ'=>'L', 'Ḽ'=>'L', 'Ľ'=>'L', 'Ŀ'=>'L', 'Ł'=>'L', 'Ḹ'=>'L', 
			'Ḿ'=>'M', 'Ṁ'=>'M', 'Ṃ'=>'M', 'Ɯ'=>'M', 'Ñ'=>'N', 'Ǹ'=>'N', 'Ń'=>'N', 'Ñ'=>'N', 'Ṅ'=>'N', 'Ň'=>'N', 'Ŋ'=>'N', 'Ɲ'=>'N', 'Ṇ'=>'N', 'Ņ'=>'N', 'Ṋ'=>'N', 'Ṉ'=>'N', 'Ƞ'=>'N',
			'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ō'=>'O', 'Ŏ'=>'O', 'Ȯ'=>'O', 'Ö'=>'O', 'Ỏ'=>'O', 'Ő'=>'O', 'Ǒ'=>'O', 'Ȍ'=>'O', 'Ȏ'=>'O', 'Ơ'=>'O', 'Ǫ'=>'O', 'Ọ'=>'O', 'Ɵ'=>'O', 'Ø'=>'O', 'Ồ'=>'O', 'Ố'=>'O', 'Ỗ'=>'O', 'Ổ'=>'O', 'Ȱ'=>'O', 'Ȫ'=>'O', 'Ȭ'=>'O', 'Ṍ'=>'O', 'Ṑ'=>'O', 'Ṓ'=>'O', 'Ờ'=>'O', 'Ớ'=>'O', 'Ỡ'=>'O', 'Ở'=>'O', 'Ợ'=>'O', 'Ǭ'=>'O', 'Ộ'=>'O', 'Ǿ'=>'O', 'Ɔ'=>'O', 'Œ'=>'OE',
			'Ṕ'=>'P', 'Ṗ'=>'P', 'Ƥ'=>'P',
			'Ŕ'=>'R', 'Ṙ'=>'R', 'Ř'=>'R',	'Ȑ'=>'R', 'Ȓ'=>'R', 'Ṛ'=>'R', 'Ŗ'=>'R', 'Ṟ'=>'R', 'Ṝ'=>'R', 'Ʀ'=>'R',
			'Ś'=>'S', 'Ŝ'=>'S', 'Ṡ'=>'S', 'Š'=>'S', 'Ṣ'=>'S', 'Ș'=>'S', 'Ş'=>'S', 'Ṥ'=>'S', 'Ṧ'=>'S', 'Ṩ'=>'S',
			'Ṫ'=>'T', 'Ť'=>'T', 'Ƭ'=>'T', 'Ʈ'=>'T', 'Ṭ'=>'T', 'Ț'=>'T', 'Ţ'=>'T', 'Ṱ'=>'T', 'Ṯ'=>'T', 'Ŧ'=>'T', 
			'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ũ'=>'U', 'Ū'=>'U', 'Ŭ'=>'U', 'Ü'=>'U', 'Ủ'=>'U', 'Ů'=>'U', 'Ű'=>'U', 'Ǔ'=>'U', 'Ȕ'=>'U', 'Ȗ'=>'U', 'Ư'=>'U', 'Ụ'=>'U', 'Ṳ'=>'U', 'Ų'=>'U', 'Ṷ'=>'U', 'Ṵ'=>'U', 	'Ṹ'=>'U', 'Ṻ'=>'U', 'Ǜ'=>'U', 'Ǘ'=>'U', 'Ǖ'=>'U', 'Ǚ'=>'U', 'Ừ'=>'U', 	'Ứ'=>'U', 'Ữ'=>'U', 'Ử'=>'U', 'Ự'=>'U',
			'Ṽ'=>'V', 'Ṿ'=>'V', 'Ʋ'=>'V',
			'Ẁ'=>'W', 'Ẃ'=>'W', 'Ŵ'=>'W', 'Ẇ'=>'W', 'Ẅ'=>'W', 'Ẉ'=>'W',
			'Ẋ'=>'X', 'Ẍ'=>'X',
			'Ỳ'=>'Y', 'Ý'=>'Y', 'Ŷ'=>'Y', 'Ỹ'=>'Y', 'Ȳ'=>'Y', 'Ẏ'=>'Y', 'Ÿ'=>'Y', 'Ỷ'=>'Y', 'Ƴ'=>'Y', 'Ỵ'=>'Y',
			'Ź'=>'Z', 'Ẑ'=>'Z', 'Ż'=>'Z', 'Ž'=>'Z', 'Ȥ'=>'Z', 'Ẓ'=>'Z', 'Ẕ'=>'Z', 'Ƶ'=>'Z',
			'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ā'=>'a', 'ă'=>'a', 'ȧ'=>'a', 'ä'=>'a', 'ả'=>'a', 'å'=>'a', 'ǎ'=>'a', 'ȁ'=>'a', 'ą'=>'a', 'ạ'=>'a', 'ḁ'=>'a', 'ẚ'=>'a', 'ầ'=>'a', 'ấ'=>'a', 'ẫ'=>'a', 'ẩ'=>'a', 'ằ'=>'a', 'ắ'=>'a', 'ẵ'=>'a', 'ẳ'=>'a', 'ǡ'=>'a', 'ǟ'=>'a', 'ǻ'=>'a', 'ậ'=>'a', 'ặ'=>'a', 
			'æ'=>'ae', 'ǽ'=>'ae', 'ǣ'=>'ae', 
			'ḃ'=>'b', 'ɓ'=>'b', 'ḅ'=>'b', 'ḇ'=>'b', 'ƀ'=>'b', 'ƃ'=>'b', 'ƅ'=>'b', 'þ'=>'b',
			'ć'=>'c', 'ĉ'=>'c', 'ċ'=>'c', 'č'=>'c', 'ƈ'=>'c', 'ç'=>'c', 'ḉ'=>'c',
			'ḋ'=>'d', 'ɗ'=>'d', 'ḍ'=>'d', 'ḏ'=>'d', 'ḑ'=>'d', 'ḓ'=>'d', 'ď'=>'d', 'đ'=>'d', 'ƌ'=>'d', 'ȡ'=>'d',
			'đ'=>'dj',
			'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ẽ'=>'e', 'ē'=>'e', 'ĕ'=>'e', 'ė'=>'e', 'ë'=>'e', 'ẻ'=>'e', 'ě'=>'e', 'ȅ'=>'e', 'ȇ'=>'e', 'ẹ'=>'e', 'ȩ'=>'e', 'ę'=>'e', 'ḙ'=>'e', 'ḛ'=>'e', 'ề'=>'e', 'ế'=>'e', 			'ễ'=>'e', 'ể'=>'e', 'ḕ'=>'e', 'ḗ'=>'e', 'ệ'=>'e', 'ḝ'=>'e', 'ǝ'=>'e', 'ɛ'=>'e', 
			'ḟ'=>'f', 'ƒ'=>'f', 
			'ǵ'=>'g', 'ĝ'=>'g', 'ḡ'=>'g', 'ğ'=>'g', 'ġ'=>'g', 'ǧ'=>'g', 'ɠ'=>'g', 'ģ'=>'g', 'ǥ'=>'g',
			'ĥ'=>'h', 'ḣ'=>'h', 'ḧ'=>'h', 'ȟ'=>'h', 'ƕ'=>'h', 'ḥ'=>'h', 'ḩ'=>'h', 'ḫ'=>'h', 'ẖ'=>'h', 'ħ'=>'h',
			'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ĩ'=>'i', 'ī'=>'i', 'ĭ'=>'i', 'ı'=>'i', 'ï'=>'i', 'ỉ'=>'i', 'ǐ'=>'i', 'ị'=>'i', 'į'=>'i', 'ȉ'=>'i', 'ȋ'=>'i', 'ḭ'=>'i',  'ɨ'=>'i', 'ḯ'=>'i',
			'ĳ'=>'ij',
			'ĵ'=>'j', 'ǰ'=>'j', 
			'ḱ'=>'k', 'ǩ'=>'k', 'ḵ'=>'k', 'ƙ'=>'k', 'ḳ'=>'k', 'ķ'=>'k',
			'ĺ'=>'l', 'ḻ'=>'l', 'ḷ'=>'l', 'ļ'=>'l', 'ḽ'=>'l', 'ľ'=>'l', 'ŀ'=>'l', 'ł'=>'l', 'ƚ'=>'l', 'ḹ'=>'l', 'ȴ'=>'l', 
			'ḿ'=>'m', 'ṁ'=>'m', 'ṃ'=>'m', 'ɯ'=>'m', 
			'ǹ'=>'n', 'ń'=>'n', 'ñ'=>'n', 'ṅ'=>'n', 'ň'=>'n', 'ŋ'=>'n', 'ɲ'=>'n', 'ṇ'=>'n', 'ņ'=>'n', 'ṋ'=>'n', 'ṉ'=>'n', 'ŉ'=>'n', 'ƞ'=>'n', 'ȵ'=>'n',
			'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ō'=>'o', 'ŏ'=>'o', 'ȯ'=>'o', 'ö'=>'o', 'ỏ'=>'o', 'ő'=>'o', 'ǒ'=>'o', 'ȍ'=>'o', 'ȏ'=>'o', 'ơ'=>'o', 'ǫ'=>'o', 'ọ'=>'o', 'ɵ'=>'o', 'ø'=>'o', 'ồ'=>'o', 'ố'=>'o', 'ỗ'=>'o', 'ổ'=>'o', 'ȱ'=>'o', 'ȫ'=>'o', 'ȭ'=>'o', 'ṍ'=>'o', 'ṏ'=>'o', 'ṑ'=>'o', 'ṓ'=>'o', 'ờ'=>'o', 'ớ'=>'o', 'ỡ'=>'o', 'ở'=>'o', 'ợ'=>'o', 'ǭ'=>'o', 'ộ'=>'o', 'ǿ'=>'o', 'ɔ'=>'o', 
			'œ'=>'oe',
			'ṕ'=>'p', 'ṗ'=>'p', 'ƥ'=>'p', 
			'ŕ'=>'r', 'ṙ'=>'r', 'ř'=>'r', 'ȑ'=>'r', 'ȓ'=>'r', 'ṛ'=>'r', 'ŗ'=>'r', 'ṟ'=>'r', 'ṝ'=>'r',
			'ś'=>'s', 'ŝ'=>'s', 'ṡ'=>'s', 'š'=>'s', 'ṣ'=>'s', 'ș'=>'s', 'ş'=>'s', 'ṥ'=>'s', 'ṧ'=>'s', 'ṩ'=>'s', 'ſ'=>'s', 'ẛ'=>'s',
			'ß'=>'Ss',			
			'ṫ'=>'t', 'ẗ'=>'t', 'ť'=>'t', 'ƭ'=>'t', 'ʈ'=>'t', 'ƫ'=>'t', 'ṭ'=>'t', 'ț'=>'t', 'ţ'=>'t', 'ṱ'=>'t', 'ṯ'=>'t', 'ŧ'=>'t', 'ȶ'=>'t',
			'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ũ'=>'u', 'ū'=>'u', 'ŭ'=>'u', 'ü'=>'u', 'ủ'=>'u', 'ů'=>'u', 'ű'=>'u', 'ǔ'=>'u', 'ȕ'=>'u', 'ȗ'=>'u', 'ư'=>'u', 'ụ'=>'u', 'ṳ'=>'u', 'ų'=>'u', 'ṷ'=>'u', 'ṵ'=>'u', 'ṹ'=>'u', 'ṻ'=>'u', 'ǜ'=>'u', 'ǘ'=>'u', 'ǖ'=>'u', 'ǚ'=>'u', 'ừ'=>'u', 'ứ'=>'u', 'ữ'=>'u', 'ử'=>'u', 'ự'=>'u', 
			'ṽ'=>'v', 'ṿ'=>'v', 
			'ẁ'=>'w', 'ẃ'=>'w', 'ŵ'=>'w', 'ẇ'=>'w', 'ẅ'=>'w', 'ẘ'=>'w', 'ẉ'=>'w',
			'ẋ'=>'x', 'ẍ'=>'x', 
			'ý'=>'y', 'ý'=>'y', 'ỳ'=>'y', 'ý'=>'y', 'ŷ'=>'y', 'ȳ'=>'y', 'ẏ'=>'y', 'ÿ'=>'y', 'ÿ'=>'y', 'ỷ'=>'y', 'ẙ'=>'y', 'ƴ'=>'y', 'ỵ'=>'y',
			'ź'=>'z', 'ẑ'=>'z', 'ż'=>'z', 'ž'=>'z', 'ȥ'=>'z', 'ẓ'=>'z', 'ẕ'=>'z', 'ƶ'=>'z',
			'№'=>'No',
			'º'=>'o',
			'ª'=>'a',
			'€'=>'E',
			'©'=>'C',
			'℗'=>'P',
			'™'=>'tm',
			'℠'=>'sm',
			'’' => '',
			'_'=>'-',
			'%20'=>'-'
		);
	
	// Force the file name in UTF-8 (encoding Windows / OS X / Linux)
	$filename = mb_convert_encoding($filename, "UTF-8");
	
	// Custom cleaning
	$filename = str_replace(array_keys($invalid), array_values($invalid), $filename);

	// WP Remove accents
	$filename = remove_accents($filename); 

	// After replacement, we destroy the last residues
	$filename = utf8_decode($filename);
	
	// Lowercase
	$filename = strtolower($filename);

	// last cleaning : remove any special char left
	// $filename = preg_replace('/\?/', '', $filename);
	$filename = preg_replace('/[^a-zA-Z0-9-_\.]/', '', $filename);
	
	// we are done
	return $filename;
}
add_filter('sanitize_file_name', 'clean_upload_filename', 10);
		
		
?>
