<?php
/*
Description: module ressources
*/

add_action( 'init', function(){
	
	// creation du nouveau post type
	register_post_type( 'ressources',
		array(
			'labels' => array(
				'name' => 'Resources',
				'singular_name' => 'Publication',
				'new_item' => 'Nouveau ',
				'view_item' => 'Afficher',
				'add_new_item' => 'Ajouter',
				'edit_item' => 'Modifier',
				'not_found' => 'Aucun élément',
				'not_found_in_trash' => 'La corbeille est vide',
			),
			'public' => true,
			'has_archive' => true,
			'publicly_queryable'  => true,
			'supports'      => array( 'title', 'author' ),
		)
	);
			
}); //init

function ressources_list_sc($atts, $contenu=null) {

$o = '';
$args = array(
	'post_type' => 'ressources',
	'posts_per_page' => -1,
	
);
	
// chargement des données
$la_posts=get_posts($args);	

foreach($la_posts as $lo_post){
		
	$post_id=$lo_post->ID;
	
	// création du contexte pour twig
	$context=get_fields($post_id);
	$context['post_title']=get_the_title($post_id);
	$context['post_name']=$lo_post->post_name;
	$context['post_content']=get_the_content($post_id);
	$context['post_permalink']=get_the_permalink($post_id);
	
	// affichage du contexte dans la console pour aider la création de la vue
	$o.= '<script>console.log('.json_encode($context).');</script>';

	// exécution de la vue twig avec les données dans $context
	$o.=Timber::compile( 'ressources-list-item.twig', $context );

}
  
	return $o;	
}

add_shortcode( 'ressources-list', 'ressources_list_sc' );